/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.avro.AvroBytesDecoder;
import org.apache.druid.data.input.avro.AvroFlattenerMaker;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;

public class AvroStreamReader
extends IntermediateRowParsingReader<GenericRecord> {
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;
    private final AvroBytesDecoder avroBytesDecoder;
    private final ObjectFlattener<GenericRecord> recordFlattener;

    AvroStreamReader(InputRowSchema inputRowSchema, InputEntity source, AvroBytesDecoder avroBytesDecoder, @Nullable JSONPathSpec flattenSpec, boolean binaryAsString, boolean extractUnionsByType) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.avroBytesDecoder = avroBytesDecoder;
        this.recordFlattener = ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new AvroFlattenerMaker(false, binaryAsString, extractUnionsByType, inputRowSchema.getDimensionsSpec().useSchemaDiscovery()));
    }

    protected CloseableIterator<GenericRecord> intermediateRowIterator() throws IOException {
        return CloseableIterators.withEmptyBaggage((Iterator)Iterators.singletonIterator((Object)this.avroBytesDecoder.parse(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)this.source.open())))));
    }

    protected InputEntity source() {
        return this.source;
    }

    protected List<InputRow> parseInputRows(GenericRecord intermediateRow) throws ParseException {
        return Collections.singletonList(MapInputRowParser.parse((InputRowSchema)this.inputRowSchema, (Map)this.recordFlattener.flatten((Object)intermediateRow)));
    }

    protected List<Map<String, Object>> toMap(GenericRecord intermediateRow) {
        return Collections.singletonList(this.recordFlattener.toMap((Object)intermediateRow));
    }
}

