/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import javax.annotation.Nullable;
import org.apache.druid.storage.s3.S3SSEKmsConfig;
import org.apache.druid.storage.s3.ServerSideEncryption;

class KmsServerSideEncryption
implements ServerSideEncryption {
    @Nullable
    private final String keyId;

    @JsonCreator
    KmsServerSideEncryption(@JacksonInject S3SSEKmsConfig config) {
        this.keyId = config.getKeyId();
    }

    @Override
    public PutObjectRequest decorate(PutObjectRequest request) {
        return request.withSSEAwsKeyManagementParams(this.keyId == null ? new SSEAwsKeyManagementParams() : new SSEAwsKeyManagementParams(this.keyId));
    }

    @Override
    public CopyObjectRequest decorate(CopyObjectRequest request) {
        return request.withSSEAwsKeyManagementParams(this.keyId == null ? new SSEAwsKeyManagementParams() : new SSEAwsKeyManagementParams(this.keyId));
    }
}

