/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSchemaRegistryClient
implements SchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(MockSchemaRegistryClient.class);
    private static final String WILDCARD = "*";
    private String defaultCompatibility = "BACKWARD";
    private final Map<String, Map<ParsedSchema, Integer>> schemaCache = new HashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<ParsedSchema, Integer> schemaIdCache = new HashMap<ParsedSchema, Integer>();
    private final Map<String, Map<Integer, ParsedSchema>> idCache = new HashMap<String, Map<Integer, ParsedSchema>>();
    private final Map<String, Map<ParsedSchema, Integer>> versionCache = new HashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<String, String> compatibilityCache = new HashMap<String, String>();
    private final Map<String, String> modes = new HashMap<String, String>();
    private final AtomicInteger ids = new AtomicInteger(0);
    private final Map<String, SchemaProvider> providers;

    public MockSchemaRegistryClient() {
        this(null);
    }

    public MockSchemaRegistryClient(List<SchemaProvider> providers) {
        this.idCache.put(null, new HashMap());
        this.providers = providers != null && !providers.isEmpty() ? providers.stream().collect(Collectors.toMap(p -> p.schemaType(), p -> p)) : Collections.singletonMap("AVRO", new AvroSchemaProvider());
        HashMap<String, MockSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, MockSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        SchemaProvider schemaProvider;
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("No provider found for schema type " + schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schemaString, references);
    }

    private int getIdFromRegistry(String subject, ParsedSchema schema, boolean registerRequest, int id) throws IOException, RestClientException {
        Map<Integer, ParsedSchema> idSchemaMap;
        if (this.idCache.containsKey(subject)) {
            idSchemaMap = this.idCache.get(subject);
            for (Map.Entry<Integer, ParsedSchema> entry : idSchemaMap.entrySet()) {
                if (!entry.getValue().canonicalString().equals(schema.canonicalString())) continue;
                if (registerRequest) {
                    if (id >= 0 && id != entry.getKey()) {
                        throw new IllegalStateException("Schema already registered with id " + entry.getKey() + " instead of input id " + id);
                    }
                    this.generateVersion(subject, schema);
                }
                return entry.getKey();
            }
        } else {
            if (!registerRequest) {
                throw new RestClientException("Subject Not Found", 404, 40401);
            }
            idSchemaMap = new HashMap<Integer, ParsedSchema>();
        }
        if (registerRequest) {
            Integer schemaId = this.schemaIdCache.get(schema);
            if (schemaId == null) {
                schemaId = id >= 0 ? id : this.ids.incrementAndGet();
                this.schemaIdCache.put(schema, schemaId);
            } else if (id >= 0 && id != schemaId) {
                throw new IllegalStateException("Schema already registered with id " + schemaId + " instead of input id " + id);
            }
            idSchemaMap.put(schemaId, schema);
            this.idCache.put(subject, idSchemaMap);
            this.generateVersion(subject, schema);
            return schemaId;
        }
        throw new RestClientException("Schema Not Found", 404, 40403);
    }

    private void generateVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        int currentVersion;
        Map<Object, Object> schemaVersionMap;
        List<Integer> versions = this.allVersions(subject);
        if (versions.isEmpty()) {
            schemaVersionMap = new HashMap();
            currentVersion = 1;
        } else {
            schemaVersionMap = this.versionCache.get(subject);
            currentVersion = versions.get(versions.size() - 1) + 1;
        }
        schemaVersionMap.put(schema, currentVersion);
        this.versionCache.put(subject, schemaVersionMap);
    }

    @Override
    public synchronized List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        if (this.versionCache.containsKey(subject)) {
            return this.allVersions(subject);
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    private synchronized List<Integer> allVersions(String subject) {
        ArrayList<Integer> versions = new ArrayList<Integer>();
        if (this.versionCache.containsKey(subject)) {
            versions.addAll(this.versionCache.get(subject).values());
            Collections.sort(versions);
        }
        return versions;
    }

    private ParsedSchema getSchemaBySubjectAndIdFromRegistry(String subject, int id) throws IOException, RestClientException {
        if (this.idCache.containsKey(subject)) {
            Map<Integer, ParsedSchema> idSchemaMap = this.idCache.get(subject);
            if (idSchemaMap.containsKey(id)) {
                return idSchemaMap.get(id);
            }
        } else {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        throw new IOException("Cannot get schema from schema registry!");
    }

    @Override
    public synchronized int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1);
    }

    @Override
    public synchronized int register(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        Map<Object, Object> schemaIdMap;
        if (this.schemaCache.containsKey(subject)) {
            schemaIdMap = this.schemaCache.get(subject);
        } else {
            schemaIdMap = new HashMap();
            this.schemaCache.put(subject, schemaIdMap);
        }
        if (schemaIdMap.containsKey(schema)) {
            int schemaId = (Integer)schemaIdMap.get(schema);
            if (id >= 0 && id != schemaId) {
                throw new IllegalStateException("Schema already registered with id " + schemaId + " instead of input id " + id);
            }
            return schemaId;
        }
        id = this.getIdFromRegistry(subject, schema, true, id);
        schemaIdMap.put(schema, id);
        if (!this.idCache.get(null).containsKey(id)) {
            this.idCache.get(null).put(id, schema);
        }
        return id;
    }

    @Override
    public synchronized ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.getSchemaBySubjectAndId(null, id);
    }

    @Override
    public synchronized ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map<Object, Object> idSchemaMap;
        if (this.idCache.containsKey(subject)) {
            idSchemaMap = this.idCache.get(subject);
        } else {
            idSchemaMap = new HashMap();
            this.idCache.put(subject, idSchemaMap);
        }
        if (idSchemaMap.containsKey(id)) {
            return (ParsedSchema)idSchemaMap.get(id);
        }
        ParsedSchema schema = this.getSchemaBySubjectAndIdFromRegistry(subject, id);
        idSchemaMap.put(id, schema);
        return schema;
    }

    private Stream<ParsedSchema> getSchemasForSubject(String subject, boolean latestOnly) {
        try {
            List<Integer> versions = this.getAllVersions(subject);
            if (latestOnly) {
                int length = versions.size();
                versions = versions.subList(length - 1, length);
            }
            LinkedList<SchemaMetadata> schemaMetadata = new LinkedList<SchemaMetadata>();
            for (Integer version : versions) {
                schemaMetadata.add(this.getSchemaMetadata(subject, version));
            }
            LinkedList<ParsedSchema> schemas = new LinkedList<ParsedSchema>();
            for (SchemaMetadata metadata : schemaMetadata) {
                schemas.add(this.getSchemaBySubjectAndId(subject, metadata.getId()));
            }
            return schemas.stream();
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        Stream<String> validSubjects = this.getAllSubjects().stream().filter(subject -> subject.startsWith(subjectPrefix));
        return validSubjects.flatMap(subject -> this.getSchemasForSubject((String)subject, latestOnly)).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        return this.idCache.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(id)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Collection<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        return this.idCache.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(id)).map(e -> {
            ParsedSchema schema = (ParsedSchema)((Map)e.getValue()).get(id);
            int version = this.versionCache.get(e.getKey()).get(schema);
            return new SubjectVersion((String)e.getKey(), version);
        }).collect(Collectors.toList());
    }

    private int getLatestVersion(String subject) throws IOException, RestClientException {
        List<Integer> versions = this.getAllVersions(subject);
        if (versions.isEmpty()) {
            throw new IOException("No schema registered under subject!");
        }
        return versions.get(versions.size() - 1);
    }

    @Override
    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        ParsedSchema schema = null;
        Map<ParsedSchema, Integer> schemaVersionMap = this.versionCache.get(subject);
        if (schemaVersionMap == null) {
            throw new RuntimeException(new RestClientException("Subject Not Found", 404, 40401));
        }
        int maxVersion = -1;
        for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
            if (version == -1) {
                if (entry.getValue() <= maxVersion) continue;
                schema = entry.getKey();
                maxVersion = entry.getValue();
                continue;
            }
            if (entry.getValue() != version) continue;
            schema = entry.getKey();
        }
        if (maxVersion != -1) {
            version = maxVersion;
        }
        int id = -1;
        Map<Integer, ParsedSchema> idSchemaMap = this.idCache.get(subject);
        for (Map.Entry<Integer, ParsedSchema> entry : idSchemaMap.entrySet()) {
            if (!entry.getValue().canonicalString().equals(schema.canonicalString())) continue;
            id = entry.getKey();
        }
        return new Schema(subject, version, id, schema.schemaType(), schema.references(), schema.canonicalString());
    }

    @Override
    public synchronized SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        ParsedSchema schema = null;
        Map<ParsedSchema, Integer> schemaVersionMap = this.versionCache.get(subject);
        if (schemaVersionMap == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
            if (entry.getValue() != version) continue;
            schema = entry.getKey();
        }
        int id = -1;
        Map<Integer, ParsedSchema> idSchemaMap = this.idCache.get(subject);
        for (Map.Entry<Integer, ParsedSchema> entry : idSchemaMap.entrySet()) {
            if (!entry.getValue().canonicalString().equals(schema.canonicalString())) continue;
            id = entry.getKey();
        }
        return new SchemaMetadata(id, version, schema.schemaType(), schema.references(), schema.canonicalString());
    }

    @Override
    public synchronized SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        int version = this.getLatestVersion(subject);
        return this.getSchemaMetadata(subject, version);
    }

    @Override
    public synchronized int getVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        if (this.versionCache.containsKey(subject)) {
            Map<ParsedSchema, Integer> versions = this.versionCache.get(subject);
            return versions.get(schema);
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    @Override
    public boolean testCompatibility(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        CompatibilityLevel compatibilityLevel;
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            compatibility = this.defaultCompatibility;
        }
        if ((compatibilityLevel = CompatibilityLevel.forName(compatibility)) == null) {
            return false;
        }
        ArrayList<ParsedSchema> schemaHistory = new ArrayList<ParsedSchema>();
        for (int version : this.allVersions(subject)) {
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(subject, version);
            schemaHistory.add(this.getSchemaBySubjectAndIdFromRegistry(subject, schemaMetadata.getId()));
        }
        return newSchema.isCompatible(compatibilityLevel, schemaHistory).isEmpty();
    }

    @Override
    public List<String> testCompatibilityVerbose(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        CompatibilityLevel compatibilityLevel;
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            compatibility = this.defaultCompatibility;
        }
        if ((compatibilityLevel = CompatibilityLevel.forName(compatibility)) == null) {
            return new LinkedList<String>(Arrays.asList("Compatibility level not specified."));
        }
        ArrayList<ParsedSchema> schemaHistory = new ArrayList<ParsedSchema>();
        for (int version : this.allVersions(subject)) {
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(subject, version);
            schemaHistory.add(this.getSchemaBySubjectAndIdFromRegistry(subject, schemaMetadata.getId()));
        }
        return newSchema.isCompatible(compatibilityLevel, schemaHistory);
    }

    @Override
    public String updateCompatibility(String subject, String compatibility) throws IOException, RestClientException {
        if (subject == null) {
            this.defaultCompatibility = compatibility;
            return compatibility;
        }
        this.compatibilityCache.put(subject, compatibility);
        return compatibility;
    }

    @Override
    public String getCompatibility(String subject) throws IOException, RestClientException {
        if (subject == null) {
            return this.defaultCompatibility;
        }
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        return compatibility;
    }

    @Override
    public String setMode(String mode) throws IOException, RestClientException {
        this.modes.put(WILDCARD, mode);
        return mode;
    }

    @Override
    public String setMode(String mode, String subject) throws IOException, RestClientException {
        this.modes.put(subject, mode);
        return mode;
    }

    @Override
    public String getMode() throws IOException, RestClientException {
        return this.modes.getOrDefault(WILDCARD, "READWRITE");
    }

    @Override
    public String getMode(String subject) throws IOException, RestClientException {
        String mode = this.modes.get(subject);
        if (mode == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        return mode;
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.schemaCache.keySet());
        Collections.sort(results, String.CASE_INSENSITIVE_ORDER);
        return results;
    }

    @Override
    public int getId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getIdFromRegistry(subject, schema, false, -1);
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSubject(null, subject, isPermanent);
    }

    @Override
    public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        this.schemaCache.remove(subject);
        this.idCache.remove(subject);
        this.versionCache.remove(subject);
        this.compatibilityCache.remove(subject);
        return Arrays.asList(0);
    }

    @Override
    public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSchemaVersion(null, subject, version, isPermanent);
    }

    @Override
    public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        if (this.versionCache.containsKey(subject)) {
            Map<ParsedSchema, Integer> schemaVersionMap = this.versionCache.get(subject);
            for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
                if (!entry.getValue().equals(Integer.valueOf(version))) continue;
                schemaVersionMap.values().remove(entry.getValue());
                if (isPermanent) {
                    this.idCache.get(subject).remove(entry.getValue());
                    this.schemaCache.get(subject).remove(entry.getKey());
                }
                return Integer.valueOf(version);
            }
        }
        return -1;
    }

    @Override
    public void reset() {
        this.schemaCache.clear();
        this.idCache.clear();
        this.versionCache.clear();
        this.idCache.put(null, new HashMap());
    }
}

