/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.authorizer;

import java.io.Closeable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;

@InterfaceStability.Evolving
public interface Authorizer
extends Configurable,
Closeable {
    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo var1);

    public List<AuthorizationResult> authorize(AuthorizableRequestContext var1, List<Action> var2);

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext var1, List<AclBinding> var2);

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext var1, List<AclBindingFilter> var2);

    public Iterable<AclBinding> acls(AclBindingFilter var1);

    default public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        SecurityUtils.authorizeByResourceTypeCheckArgs(op, resourceType);
        if (this.authorize(requestContext, Collections.singletonList(new Action(op, new ResourcePattern(resourceType, "hardcode", PatternType.LITERAL), 0, true, false))).get(0) == AuthorizationResult.ALLOWED) {
            return AuthorizationResult.ALLOWED;
        }
        ResourcePatternFilter resourceTypeFilter = new ResourcePatternFilter(resourceType, null, PatternType.ANY);
        AclBindingFilter aclFilter = new AclBindingFilter(resourceTypeFilter, AccessControlEntryFilter.ANY);
        EnumMap<PatternType, Set<String>> denyPatterns = new EnumMap<PatternType, Set<String>>(PatternType.class){
            {
                this.put(PatternType.LITERAL, new HashSet());
                this.put(PatternType.PREFIXED, new HashSet());
            }
        };
        EnumMap<PatternType, Set<String>> allowPatterns = new EnumMap<PatternType, Set<String>>(PatternType.class){
            {
                this.put(PatternType.LITERAL, new HashSet());
                this.put(PatternType.PREFIXED, new HashSet());
            }
        };
        boolean hasWildCardAllow = false;
        KafkaPrincipal principal = new KafkaPrincipal(requestContext.principal().getPrincipalType(), requestContext.principal().getName());
        String hostAddr = requestContext.clientAddress().getHostAddress();
        block8: for (AclBinding aclBinding : this.acls(aclFilter)) {
            if (!aclBinding.entry().host().equals(hostAddr) && !aclBinding.entry().host().equals("*") || !SecurityUtils.parseKafkaPrincipal(aclBinding.entry().principal()).equals(principal) && !aclBinding.entry().principal().equals("User:*") || aclBinding.entry().operation() != op && aclBinding.entry().operation() != AclOperation.ALL) continue;
            if (aclBinding.entry().permissionType() == AclPermissionType.DENY) {
                switch (aclBinding.pattern().patternType()) {
                    case LITERAL: {
                        if (aclBinding.pattern().name().equals("*")) {
                            return AuthorizationResult.DENIED;
                        }
                        ((Set)denyPatterns.get((Object)PatternType.LITERAL)).add(aclBinding.pattern().name());
                        continue block8;
                    }
                    case PREFIXED: {
                        ((Set)denyPatterns.get((Object)PatternType.PREFIXED)).add(aclBinding.pattern().name());
                        continue block8;
                    }
                }
                continue;
            }
            if (aclBinding.entry().permissionType() != AclPermissionType.ALLOW) continue;
            switch (aclBinding.pattern().patternType()) {
                case LITERAL: {
                    if (aclBinding.pattern().name().equals("*")) {
                        hasWildCardAllow = true;
                        break;
                    }
                    ((Set)allowPatterns.get((Object)PatternType.LITERAL)).add(aclBinding.pattern().name());
                    break;
                }
                case PREFIXED: {
                    ((Set)allowPatterns.get((Object)PatternType.PREFIXED)).add(aclBinding.pattern().name());
                    break;
                }
            }
        }
        if (hasWildCardAllow) {
            return AuthorizationResult.ALLOWED;
        }
        for (Map.Entry entry : allowPatterns.entrySet()) {
            for (String allowStr : (Set)entry.getValue()) {
                if (entry.getKey() == PatternType.LITERAL && ((Set)denyPatterns.get((Object)PatternType.LITERAL)).contains(allowStr)) continue;
                StringBuilder sb = new StringBuilder();
                boolean hasDominatedDeny = false;
                for (char ch : allowStr.toCharArray()) {
                    sb.append(ch);
                    if (!((Set)denyPatterns.get((Object)PatternType.PREFIXED)).contains(sb.toString())) continue;
                    hasDominatedDeny = true;
                    break;
                }
                if (hasDominatedDeny) continue;
                return AuthorizationResult.ALLOWED;
            }
        }
        return AuthorizationResult.DENIED;
    }
}

