/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.orc;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.data.input.orc.OrcStructConverter;
import org.apache.druid.java.util.common.parsers.FlattenerJsonProvider;
import org.apache.hadoop.io.Text;
import org.apache.orc.mapred.OrcMap;
import org.apache.orc.mapred.OrcStruct;

public class OrcStructJsonProvider
extends FlattenerJsonProvider {
    private final OrcStructConverter converter;

    OrcStructJsonProvider(OrcStructConverter converter) {
        this.converter = converter;
    }

    public boolean isArray(Object o) {
        return o instanceof List;
    }

    public boolean isMap(Object o) {
        return o == null || o instanceof Map || o instanceof OrcStruct;
    }

    public Collection<String> getPropertyKeys(Object o) {
        if (o == null) {
            return Collections.emptySet();
        }
        if (o instanceof Map) {
            return ((Map)o).keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        }
        if (o instanceof OrcStruct) {
            return ((OrcStruct)o).getSchema().getFieldNames();
        }
        throw new UnsupportedOperationException(o.getClass().getName());
    }

    public Object getMapValue(Object o, String s) {
        if (o == null) {
            return null;
        }
        if (o instanceof OrcMap) {
            OrcMap map = (OrcMap)o;
            return map.get((Object)new Text(s));
        }
        if (o instanceof Map) {
            return ((Map)o).get(s);
        }
        if (o instanceof OrcStruct) {
            OrcStruct struct = (OrcStruct)o;
            return this.converter.convertField(struct, struct.getSchema().getFieldNames().indexOf(s));
        }
        throw new UnsupportedOperationException(o.getClass().getName());
    }
}

