/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesis.model.StreamSummary;
import java.util.Date;

@SdkInternalApi
public class StreamSummaryMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final MarshallingInfo<String> STREAMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamStatus").build();
    private static final MarshallingInfo<StructuredPojo> STREAMMODEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamModeDetails").build();
    private static final MarshallingInfo<Date> STREAMCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamCreationTimestamp").timestampFormat("unixTimestampInMillis").build();
    private static final StreamSummaryMarshaller instance = new StreamSummaryMarshaller();

    public static StreamSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(StreamSummary streamSummary, ProtocolMarshaller protocolMarshaller) {
        if (streamSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamSummary.getStreamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)streamSummary.getStreamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)streamSummary.getStreamStatus(), STREAMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)streamSummary.getStreamModeDetails(), STREAMMODEDETAILS_BINDING);
            protocolMarshaller.marshall((Object)streamSummary.getStreamCreationTimestamp(), STREAMCREATIONTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

