/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.util.Objects;
import org.apache.druid.guice.BloomFilterSerializersModule;
import org.apache.druid.query.filter.BloomKFilter;

public class BloomKFilterHolder {
    private final BloomKFilter filter;
    private final HashCode hash;

    public BloomKFilterHolder(BloomKFilter filter, HashCode hash) {
        this.filter = filter;
        this.hash = hash;
    }

    BloomKFilter getFilter() {
        return this.filter;
    }

    HashCode getFilterHash() {
        return this.hash;
    }

    public static BloomKFilterHolder fromBloomKFilter(BloomKFilter filter) throws IOException {
        byte[] bytes = BloomFilterSerializersModule.bloomKFilterToBytes(filter);
        return new BloomKFilterHolder(filter, Hashing.sha512().hashBytes(bytes));
    }

    public static BloomKFilterHolder fromBytes(byte[] bytes) throws IOException {
        return new BloomKFilterHolder(BloomFilterSerializersModule.bloomKFilterFromBytes(bytes), Hashing.sha512().hashBytes(bytes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomKFilterHolder that = (BloomKFilterHolder)o;
        return Objects.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.hash);
    }
}

