/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.azure.storage.blob.models.BlobItem;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.druid.data.input.azure.AzureStorageAccountInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;

public class AzureCloudBlobIterator
implements Iterator<CloudBlobHolder> {
    private static final Logger log = new Logger(AzureCloudBlobIterator.class);
    private final Iterator<URI> prefixesIterator;
    private final int maxListingLength;
    private AzureStorage storage;
    private String currentStorageAccount;
    private String currentContainer;
    private String currentPrefix;
    private CloudBlobHolder currentBlobItem;
    private Iterator<BlobItem> blobItemIterator;
    private final AzureAccountConfig config;

    @AssistedInject
    AzureCloudBlobIterator(@Assisted AzureStorage azureStorage, AzureAccountConfig config, @Assisted Iterable<URI> prefixes, @Assisted int maxListingLength) {
        this.storage = azureStorage;
        this.config = config;
        this.prefixesIterator = prefixes.iterator();
        this.maxListingLength = maxListingLength;
        this.currentStorageAccount = null;
        this.currentContainer = null;
        this.currentPrefix = null;
        this.currentBlobItem = null;
        this.blobItemIterator = null;
        if (this.prefixesIterator.hasNext()) {
            this.prepareNextRequest();
            this.fetchNextBatch();
            this.advanceBlobItem();
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentBlobItem != null;
    }

    @Override
    public CloudBlobHolder next() {
        if (this.currentBlobItem == null) {
            throw new NoSuchElementException();
        }
        CloudBlobHolder retVal = this.currentBlobItem;
        this.advanceBlobItem();
        return retVal;
    }

    private void prepareNextRequest() {
        URI currentUri = this.prefixesIterator.next();
        if (currentUri.getScheme().equals("azureStorage")) {
            CloudObjectLocation cloudObjectLocation = new CloudObjectLocation(currentUri);
            Pair<String, String> containerInfo = AzureStorageAccountInputSource.getContainerAndPathFromObjectLocation(cloudObjectLocation);
            this.currentStorageAccount = cloudObjectLocation.getBucket();
            this.currentContainer = (String)containerInfo.lhs;
            this.currentPrefix = (String)containerInfo.rhs;
        } else {
            this.currentStorageAccount = this.config.getAccount();
            this.currentContainer = currentUri.getAuthority();
            this.currentPrefix = AzureUtils.extractAzureKey(currentUri);
        }
        log.debug("currentUri: %s\ncurrentContainer: %s\ncurrentPrefix: %s", new Object[]{currentUri, this.currentContainer, this.currentPrefix});
    }

    private void fetchNextBatch() {
        try {
            log.debug("fetching up to %s resources in container '%s' with prefix '%s'", new Object[]{this.maxListingLength, this.currentContainer, this.currentPrefix});
            this.blobItemIterator = this.storage.listBlobsWithPrefixInContainerSegmented(this.currentStorageAccount, this.currentContainer, this.currentPrefix, this.maxListingLength, this.config.getMaxTries()).stream().iterator();
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Failed to get blob item  from Azure container[%s], prefix[%s]. Error: %s", new Object[]{this.currentContainer, this.currentPrefix, e.getMessage()});
        }
    }

    private void advanceBlobItem() {
        while (this.prefixesIterator.hasNext() || this.blobItemIterator.hasNext()) {
            while (this.blobItemIterator.hasNext()) {
                BlobItem blobItem = this.blobItemIterator.next();
                if (blobItem.isPrefix().booleanValue() || blobItem.getProperties().getContentLength() <= 0L) continue;
                this.currentBlobItem = new CloudBlobHolder(blobItem, this.currentContainer, this.currentStorageAccount);
                return;
            }
            if (!this.prefixesIterator.hasNext()) continue;
            this.prepareNextRequest();
            this.fetchNextBatch();
        }
        this.currentBlobItem = null;
    }
}

