/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.AgentIdSourceType;
import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.common.util.IdValidateUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Objects;

public class IdValidator {
    private final BootLogger logger = BootLogger.getLogger(this.getClass());
    private static final int MAX_ID_LENGTH = 24;
    private static final int MAX_NAME_LENGTH = 255;
    private final int maxSize;

    public IdValidator(int maxSize) {
        this.maxSize = maxSize;
    }

    public IdValidator() {
        this(24);
    }

    public boolean validateAgentId(AgentIdSourceType type, String agentId) {
        Objects.requireNonNull(agentId, "agentId");
        return this.validate0((Object)((Object)type) + " agentId", agentId);
    }

    public boolean validateApplicationName(AgentIdSourceType type, String applicationName) {
        Objects.requireNonNull(applicationName, "applicationName");
        return this.validate0((Object)((Object)type) + " applicationName", applicationName);
    }

    public boolean validateAgentName(AgentIdSourceType type, String agentName) {
        if (StringUtils.isEmpty((String)agentName)) {
            return false;
        }
        return this.validate0((Object)((Object)type) + " agentName", agentName, 255);
    }

    private boolean validate0(String keyName, String keyValue) {
        return this.validate0(keyName, keyValue, this.maxSize);
    }

    private boolean validate0(String keyName, String keyValue, int maxSize) {
        this.logger.info("check " + keyName + ":" + keyValue);
        if (!IdValidateUtils.validateId((String)keyValue, (int)maxSize)) {
            this.logger.info("invalid Id. " + keyName + " can only contain [a-zA-Z0-9], '.', '-', '_'. maxLength:" + maxSize + " value:" + keyValue);
            return false;
        }
        return true;
    }
}

