/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc;

import com.navercorp.pinpoint.bootstrap.util.PlatformClassLoaderUtils;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import java.util.function.Consumer;

public final class SqlModule {
    private static final boolean SQL_MODULE = SqlModule.existSqlModule();
    private static final Class<?> SQL_DATE;
    private static final Class<?> SQL_TIME;
    private static final Class<?> SQL_TIMESTAMP;
    private static final Class<?> SQL_CLOB;
    private static final Class<?> SQL_BLOB;
    private static final Class<?> SQL_CONNECTION;
    private static final Class<?> SQL_PREPARED_STATEMENT;

    private static boolean existSqlModule() {
        if (JvmUtils.getVersion().onOrAfter(JvmVersion.JAVA_9)) {
            return PlatformClassLoaderUtils.findClassFromPlatformClassLoader("java.sql.Date") != null;
        }
        return true;
    }

    private SqlModule() {
    }

    public static boolean isSqlModuleEnable() {
        return SQL_MODULE;
    }

    public static Class<?> getSqlDate() {
        return SQL_DATE;
    }

    public static Class<?> getSqlTime() {
        return SQL_TIME;
    }

    public static Class<?> getSqlTimestamp() {
        return SQL_TIMESTAMP;
    }

    public static Class<?> getSqlClob() {
        return SQL_CLOB;
    }

    public static Class<?> getSqlBlob() {
        return SQL_BLOB;
    }

    public static Class<?> getSqlConnection() {
        return SQL_CONNECTION;
    }

    public static Class<?> getSqlPreparedStatement() {
        return SQL_PREPARED_STATEMENT;
    }

    private static Class<?> getSqlClass(String className) {
        Class<?> clazz = PlatformClassLoaderUtils.findClassFromPlatformClassLoader(className);
        if (clazz == null) {
            throw new IllegalStateException(className + " class not exist");
        }
        return clazz;
    }

    public static void register(Consumer<Class<?>> consumer) {
        if (SQL_MODULE) {
            consumer.accept(SqlModule.getSqlDate());
            consumer.accept(SqlModule.getSqlTime());
            consumer.accept(SqlModule.getSqlTimestamp());
        }
    }

    static {
        if (SQL_MODULE) {
            SQL_DATE = SqlModule.getSqlClass("java.sql.Date");
            SQL_TIME = SqlModule.getSqlClass("java.sql.Time");
            SQL_TIMESTAMP = SqlModule.getSqlClass("java.sql.Timestamp");
            SQL_CLOB = SqlModule.getSqlClass("java.sql.Clob");
            SQL_BLOB = SqlModule.getSqlClass("java.sql.Blob");
            SQL_CONNECTION = SqlModule.getSqlClass("java.sql.Connection");
            SQL_PREPARED_STATEMENT = SqlModule.getSqlClass("java.sql.PreparedStatement");
        } else {
            SQL_DATE = null;
            SQL_TIME = null;
            SQL_TIMESTAMP = null;
            SQL_CLOB = null;
            SQL_BLOB = null;
            SQL_CONNECTION = null;
            SQL_PREPARED_STATEMENT = null;
        }
    }
}

