/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.consul.service;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HeatBeatScheduler {
    private final ConsulClient consulClient;
    private final ConcurrentHashMap<String, NewService> heartBeatMap = new ConcurrentHashMap();
    private final ScheduledExecutorService heartbeatServiceExecutor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("ConsulHeartbeatService");
        return thread;
    });

    public HeatBeatScheduler(ConsulClient consulClient) {
        this.consulClient = consulClient;
    }

    protected void startHeartBeat(NewService newService, String aclToken) {
        this.heartbeatServiceExecutor.execute(new HeartBeat(newService, aclToken));
        this.heartBeatMap.put(newService.getName(), newService);
    }

    private void stopHeartBeat(NewService newService) {
        this.heartBeatMap.remove(newService.getName());
    }

    class HeartBeat
    implements Runnable {
        private static final String CHECK_ID_PREFIX = "service:";
        private String checkId;
        private final String aclToken;
        private final NewService instance;

        public HeartBeat(NewService instance, String aclToken) {
            this.instance = instance;
            this.checkId = instance.getId();
            this.aclToken = aclToken;
            if (!this.checkId.startsWith(CHECK_ID_PREFIX)) {
                this.checkId = CHECK_ID_PREFIX + this.checkId;
            }
        }

        @Override
        public void run() {
            try {
                if (this.aclToken != null) {
                    HeatBeatScheduler.this.consulClient.agentCheckPass(this.checkId, this.aclToken);
                    return;
                }
                if (HeatBeatScheduler.this.heartBeatMap.containsValue(this.instance)) {
                    HeatBeatScheduler.this.consulClient.agentCheckPass(this.checkId);
                }
            }
            finally {
                HeatBeatScheduler.this.heartbeatServiceExecutor.schedule(this, 3000L, TimeUnit.SECONDS);
            }
        }
    }
}

