/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.exception;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.annotation.Annotations;
import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecorder;
import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecordingState;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionContext;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapperFactory;
import com.navercorp.pinpoint.profiler.context.exception.sampler.ExceptionChainSampler;
import java.util.Objects;

public class DefaultExceptionRecorder
implements ExceptionRecorder {
    private final ExceptionChainSampler exceptionChainSampler;
    private final ExceptionWrapperFactory exceptionWrapperFactory;
    private final ExceptionContext exceptionContext;

    public DefaultExceptionRecorder(ExceptionChainSampler exceptionChainSampler, ExceptionWrapperFactory exceptionWrapperFactory, ExceptionContext exceptionContext) {
        this.exceptionChainSampler = Objects.requireNonNull(exceptionChainSampler, "exceptionTraceSampler");
        this.exceptionWrapperFactory = Objects.requireNonNull(exceptionWrapperFactory, "exceptionWrapperFactory");
        this.exceptionContext = Objects.requireNonNull(exceptionContext, "exceptionContext");
    }

    public void recordException(Throwable current, long startTime) {
        ExceptionContext context = this.exceptionContext;
        ExceptionRecordingState state = context.stateOf(current);
        ExceptionChainSampler.SamplingState samplingState = this.getSamplingState(state, context);
        state.pushThenUpdate(context, current, startTime, samplingState, this.exceptionWrapperFactory);
    }

    private ExceptionChainSampler.SamplingState getSamplingState(ExceptionRecordingState state, ExceptionContext context) {
        if (state.needsNewChainId()) {
            return this.exceptionChainSampler.isNewSampled();
        }
        return context.getSamplingState();
    }

    public void recordExceptionIdAnnotation(SpanEvent spanEvent) {
        ExceptionContext context = this.exceptionContext;
        if (context.hasValidExceptionId()) {
            Annotation<Long> chainId = Annotations.of(AnnotationKey.EXCEPTION_CHAIN_ID.getCode(), context.getExceptionId());
            spanEvent.addAnnotation(chainId);
        }
    }

    @Override
    public void recordException(SpanEvent spanEvent, Throwable throwable) {
        this.recordException(throwable, spanEvent.getStartTime());
        this.recordExceptionIdAnnotation(spanEvent);
    }

    @Override
    public void close() {
        ExceptionRecordingState.flush(this.exceptionContext, this.exceptionContext.getSamplingState(), this.exceptionWrapperFactory);
        this.exceptionContext.flush();
    }
}

