/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.DataType;
import com.navercorp.pinpoint.common.util.IntStringStringValue;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.annotation.Annotations;
import com.navercorp.pinpoint.profiler.metadata.DefaultParsingResult;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.ParsingResultInternal;
import com.navercorp.pinpoint.profiler.metadata.SqlCacheService;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaData;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import java.util.Objects;

public class DefaultSqlMetaDataService
implements SqlMetaDataService {
    private static final DefaultParsingResult EMPTY_RESULT = new DefaultParsingResult("");
    private final SqlCacheService<Integer> sqlCacheService;

    public DefaultSqlMetaDataService(SqlCacheService<Integer> sqlCacheService) {
        this.sqlCacheService = Objects.requireNonNull(sqlCacheService, "sqlCacheService");
    }

    @Override
    public ParsingResult wrapSqlResult(String sql) {
        if (sql == null) {
            return EMPTY_RESULT;
        }
        return new DefaultParsingResult(sql);
    }

    @Override
    public Annotation<?> newSqlAnnotation(ParsingResult parsingResult, String bindValue) {
        if (!(parsingResult instanceof DefaultParsingResult)) {
            throw new IllegalStateException("Unexpected DefaultParsingResult :" + parsingResult);
        }
        DefaultParsingResult result = (DefaultParsingResult)parsingResult;
        if (result != EMPTY_RESULT) {
            this.sqlCacheService.cacheSql(result, DefaultSqlMetaDataService::newSqlMetaData);
        }
        String output = StringUtils.defaultIfEmpty((String)parsingResult.getOutput(), null);
        bindValue = StringUtils.defaultIfEmpty((String)bindValue, null);
        IntStringStringValue sqlValue = new IntStringStringValue(((Integer)((ParsingResultInternal)result).getId()).intValue(), output, bindValue);
        return Annotations.of(AnnotationKey.SQL_ID.getCode(), (DataType)sqlValue);
    }

    static MetaDataType newSqlMetaData(ParsingResultInternal<Integer> parsingResult) {
        return new SqlMetaData(parsingResult.getId(), parsingResult.getSql());
    }
}

