/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util.queue;

import com.navercorp.pinpoint.profiler.util.queue.ArrayViewList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class ArrayBuffer<E> {
    private final int bufferSize;
    private E[] buffer;
    private int offset;

    public ArrayBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void put(List<E> elements) {
        if (this.buffer == null) {
            this.buffer = this.newBuffer(Math.max(elements.size(), this.bufferSize));
        }
        this.checkExpand(elements.size());
        if (elements instanceof RandomAccess) {
            for (int i = 0; i < elements.size(); ++i) {
                this.buffer[this.offset++] = elements.get(i);
            }
        } else {
            for (E element : elements) {
                this.buffer[this.offset++] = element;
            }
        }
    }

    private void checkExpand(int capacity) {
        int remain = this.remaining();
        if (remain >= capacity) {
            return;
        }
        int length = Math.max(this.buffer.length, 1);
        int expandedBufferSize = this.computeExpandedBufferSize(capacity, length, remain);
        this.buffer = Arrays.copyOf(this.buffer, expandedBufferSize);
    }

    private int computeExpandedBufferSize(int size, int length, int remain) {
        int expandedBufferSize = 0;
        while (remain < size) {
            expandedBufferSize = length <<= 1;
            remain = expandedBufferSize - this.offset;
        }
        return expandedBufferSize;
    }

    private int remaining() {
        return this.buffer.length - this.offset;
    }

    public void put(E e) {
        if (this.buffer == null) {
            this.buffer = this.newBuffer(this.bufferSize);
        }
        this.checkExpand(1);
        this.buffer[this.offset++] = e;
    }

    public boolean isOverflow() {
        return this.size() >= this.bufferSize;
    }

    private E[] newBuffer(int size) {
        this.offset = 0;
        return new Object[size];
    }

    public List<E> drain() {
        if (this.offset == 0) {
            return Collections.emptyList();
        }
        E[] oldBuffer = this.buffer;
        this.buffer = null;
        int currentIndex = this.offset;
        this.offset = 0;
        return new ArrayViewList<E>(oldBuffer, currentIndex);
    }

    public int size() {
        return this.offset;
    }

    public String toString() {
        return "ArrayBuffer{bufferSize=" + this.bufferSize + ", offset=" + this.offset + ", buffer=" + Arrays.toString(this.buffer) + '}';
    }
}

