/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HttpClientGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AsyncHttpProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace
public class QuerySubscriptionProcessor
implements AsyncHttpProcessor {
    private static final Logger HTTP_LOGGER = LoggerFactory.getLogger((String)"http");
    private final transient EventMeshHTTPServer eventMeshHTTPServer;

    public QuerySubscriptionProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void handler(HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        AsyncContext<HttpEventWrapper> asyncContext = handlerSpecific.getAsyncContext();
        ChannelHandlerContext ctx = handlerSpecific.getCtx();
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        HTTP_LOGGER.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        HashMap<String, Object> responseHeaderMap = new HashMap<String, Object>();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster());
        responseHeaderMap.put("eventmeship", IPUtils.getLocalAddress());
        responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv());
        responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
        long startTime = System.currentTimeMillis();
        try {
            CompleteHandler<HttpEventWrapper> handler = httpEventWrapper -> {
                try {
                    HTTP_LOGGER.debug("{}", httpEventWrapper);
                    this.eventMeshHTTPServer.sendResponse(ctx, httpEventWrapper.httpResponse());
                    this.eventMeshHTTPServer.getEventMeshHttpMetricsManager().getHttpMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - requestWrapper.getReqTime());
                }
                catch (Exception ex) {
                    HTTP_LOGGER.warn("query subscription, sendResponse fail", (Throwable)ex);
                }
            };
            HashMap<String, Collection<Object>> responseBodyMap = new HashMap<String, Collection<Object>>();
            responseBodyMap.put("subsrciption", HttpClientGroupMapping.getInstance().querySubscription());
            responseBodyMap.put("localTopicSet", HttpClientGroupMapping.getInstance().getLocalTopicSet());
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper, handler);
        }
        catch (Exception e) {
            HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2));
            HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            responseWrapper.setHttpResponseStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_RUNTIME_ERR, responseHeaderMap, responseBodyMap, null);
            long endTime = System.currentTimeMillis();
            HTTP_LOGGER.warn("query subscription fail,eventMesh2client|cost={}ms", (Object)(endTime - startTime), (Object)e);
            this.eventMeshHTTPServer.getEventMeshHttpMetricsManager().getHttpMetrics().recordSendMsgFailed();
            this.eventMeshHTTPServer.getEventMeshHttpMetricsManager().getHttpMetrics().recordSendMsgCost(endTime - startTime);
        }
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.SUBSCRIPTION_QUERY.getRequestURI()};
    }

    @Override
    public Executor executor() {
        return this.eventMeshHTTPServer.getHttpThreadPoolGroup().getClientManageExecutor();
    }
}

