/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.producer;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.api.meta.bo.EventMeshServicePubTopicInfo;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerTopicManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProducerTopicManager.class);
    private final EventMeshServer eventMeshServer;
    private transient ScheduledFuture<?> scheduledTask;
    protected static ScheduledExecutorService scheduler;
    private final ConcurrentHashMap<String, EventMeshServicePubTopicInfo> eventMeshServicePubTopicInfoMap = new ConcurrentHashMap(64);

    public ProducerTopicManager(EventMeshServer eventMeshServer) {
        this.eventMeshServer = eventMeshServer;
    }

    public void init() {
        scheduler = ThreadPoolFactory.createScheduledExecutor((int)Runtime.getRuntime().availableProcessors(), (ThreadFactory)new EventMeshThreadFactory("Producer-Topic-Manager", true));
        log.info("ProducerTopicManager inited......");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start() {
        if (this.scheduledTask == null) {
            Class<ProducerTopicManager> clazz = ProducerTopicManager.class;
            // MONITORENTER : org.apache.eventmesh.runtime.core.protocol.http.producer.ProducerTopicManager.class
            this.scheduledTask = scheduler.scheduleAtFixedRate(() -> {
                try {
                    if (!this.eventMeshServer.getConfiguration().isEventMeshServerMetaStorageEnable()) {
                        return;
                    }
                    List<EventMeshServicePubTopicInfo> pubTopicInfoList = this.eventMeshServer.getMetaStorage().findEventMeshServicePubTopicInfos();
                    Optional.ofNullable(pubTopicInfoList).ifPresent(lt -> lt.forEach(item -> this.eventMeshServicePubTopicInfoMap.put(item.getService(), (EventMeshServicePubTopicInfo)item)));
                }
                catch (Exception e) {
                    log.error("ProducerTopicManager update eventMesh pub topic info error. ", (Throwable)e);
                }
            }, 5L, 20L, TimeUnit.SECONDS);
            // MONITOREXIT : clazz
        }
        log.info("ProducerTopicManager started......");
    }

    public void shutdown() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
        }
        log.info("ProducerTopicManager shutdown......");
    }

    public ConcurrentHashMap<String, EventMeshServicePubTopicInfo> getEventMeshServicePubTopicInfoMap() {
        return this.eventMeshServicePubTopicInfoMap;
    }

    public EventMeshServicePubTopicInfo getEventMeshServicePubTopicInfo(String producerGroup) {
        return this.eventMeshServicePubTopicInfoMap.get(producerGroup);
    }
}

