/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.op;

import com.google.protobuf.ByteString;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.api.Compare;

public abstract class CmpTarget<T> {
    private final Compare.CompareTarget target;
    private final T targetValue;

    public static VersionCmpTarget version(long version) {
        return new VersionCmpTarget(version);
    }

    public static CreateRevisionCmpTarget createRevision(long revision) {
        return new CreateRevisionCmpTarget(revision);
    }

    public static ModRevisionCmpTarget modRevision(long revision) {
        return new ModRevisionCmpTarget(revision);
    }

    public static ValueCmpTarget value(ByteSequence value) {
        return new ValueCmpTarget(ByteString.copyFrom((byte[])value.getBytes()));
    }

    protected CmpTarget(Compare.CompareTarget target, T targetValue) {
        this.target = target;
        this.targetValue = targetValue;
    }

    public Compare.CompareTarget getTarget() {
        return this.target;
    }

    public T getTargetValue() {
        return this.targetValue;
    }

    private static final class ValueCmpTarget
    extends CmpTarget<ByteString> {
        ValueCmpTarget(ByteString targetValue) {
            super(Compare.CompareTarget.VALUE, targetValue);
        }
    }

    private static final class ModRevisionCmpTarget
    extends CmpTarget<Long> {
        ModRevisionCmpTarget(Long targetValue) {
            super(Compare.CompareTarget.MOD, targetValue);
        }
    }

    private static final class CreateRevisionCmpTarget
    extends CmpTarget<Long> {
        CreateRevisionCmpTarget(Long targetValue) {
            super(Compare.CompareTarget.CREATE, targetValue);
        }
    }

    private static final class VersionCmpTarget
    extends CmpTarget<Long> {
        VersionCmpTarget(Long targetValue) {
            super(Compare.CompareTarget.VERSION, targetValue);
        }
    }
}

