/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.chatgpt.source.handlers;

import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import org.apache.eventmesh.connector.chatgpt.source.dto.ChatGPTRequestDTO;
import org.apache.eventmesh.connector.chatgpt.source.managers.OpenaiManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatHandler.class);
    private final OpenaiManager openaiManager;

    public ChatHandler(OpenaiManager openaiManager) {
        this.openaiManager = openaiManager;
    }

    public CloudEvent invoke(ChatGPTRequestDTO event) {
        return this.genGptConnectRecord(event);
    }

    private CloudEvent genGptConnectRecord(ChatGPTRequestDTO event) {
        ArrayList<ChatMessage> chatMessages = new ArrayList<ChatMessage>();
        chatMessages.add(new ChatMessage(ChatMessageRole.USER.value(), event.getText()));
        ChatCompletionRequest req = this.openaiManager.newChatCompletionRequest(chatMessages);
        String chatResult = this.openaiManager.getResult(req);
        return ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withSource(URI.create(event.getSource())).withType(event.getType()).withTime(ZonedDateTime.now().toOffsetDateTime()).withData(chatResult.getBytes())).withSubject(event.getSubject()).withDataContentType(event.getDataContentType()).build();
    }
}

