/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.useradministration.data.RoleData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class RoleSheetPopulator
extends AbstractWorkbookPopulator {
    private List<RoleData> rolesList;
    private static final int ID_COL = 0;
    private static final int ROLE_NAME = 1;

    public RoleSheetPopulator(List<RoleData> roles) {
        this.rolesList = roles;
    }

    public void populate(Workbook workbook, String dateFormat) {
        int rowIndex = 1;
        Sheet rolesSheet = workbook.createSheet("Roles");
        this.setLayout(rolesSheet);
        this.populateRoles(rolesSheet, rowIndex);
        rolesSheet.protectSheet("");
    }

    private void populateRoles(Sheet rolesSheet, int rowIndex) {
        for (RoleData role : this.rolesList) {
            Row row = rolesSheet.createRow(rowIndex);
            this.writeLong(0, row, role.getId().longValue());
            this.writeString(1, row, role.getName().trim().replaceAll("[ )(]", "_"));
            ++rowIndex;
        }
    }

    private void setLayout(Sheet rolesSheet) {
        rolesSheet.setColumnWidth(0, 4000);
        rolesSheet.setColumnWidth(1, 6000);
        Row rowHeader = rolesSheet.createRow(0);
        rowHeader.setHeight((short)500);
        this.writeString(0, rowHeader, "ID");
        this.writeString(1, rowHeader, "Role Name");
    }
}

