/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.service;

import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.apache.fineract.infrastructure.event.business.BusinessEventListener;
import org.apache.fineract.infrastructure.event.business.domain.client.ClientCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.deposit.FixedDepositAccountCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.deposit.RecurringDepositAccountCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.group.CentersCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.group.GroupsCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanApprovedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanChargebackTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanCloseAsRescheduleBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanCloseBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.product.LoanProductCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionMakeRepaymentPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsApproveBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsCloseBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsPostInterestBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.transaction.SavingsDepositBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.share.ShareAccountApproveBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.share.ShareAccountCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.share.ShareProductDividentsCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.notification.service.NotificationDomainService;
import org.apache.fineract.notification.service.NotificationDomainServiceImpl;
import org.apache.fineract.notification.service.UserNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationDomainServiceImpl
implements NotificationDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationDomainServiceImpl.class);
    private final BusinessEventNotifierService businessEventNotifierService;
    private final PlatformSecurityContext context;
    private final UserNotificationService userNotificationService;

    @PostConstruct
    public void addListeners() {
        this.businessEventNotifierService.addPostBusinessEventListener(ClientCreateBusinessEvent.class, (BusinessEventListener)new ClientCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(SavingsApproveBusinessEvent.class, (BusinessEventListener)new SavingsAccountApprovedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(CentersCreateBusinessEvent.class, (BusinessEventListener)new CenterCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(GroupsCreateBusinessEvent.class, (BusinessEventListener)new GroupCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(SavingsDepositBusinessEvent.class, (BusinessEventListener)new SavingsAccountDepositListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(ShareProductDividentsCreateBusinessEvent.class, (BusinessEventListener)new ShareProductDividendCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(FixedDepositAccountCreateBusinessEvent.class, (BusinessEventListener)new FixedDepositAccountCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(RecurringDepositAccountCreateBusinessEvent.class, (BusinessEventListener)new RecurringDepositAccountCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(SavingsPostInterestBusinessEvent.class, (BusinessEventListener)new SavingsPostInterestListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanCreatedBusinessEvent.class, (BusinessEventListener)new LoanCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanApprovedBusinessEvent.class, (BusinessEventListener)new LoanApprovedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanCloseBusinessEvent.class, (BusinessEventListener)new LoanClosedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanChargebackTransactionBusinessEvent.class, (BusinessEventListener)new LoanChargebackTransactionListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanCloseAsRescheduleBusinessEvent.class, (BusinessEventListener)new LoanCloseAsRescheduledListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanTransactionMakeRepaymentPostBusinessEvent.class, (BusinessEventListener)new LoanMakeRepaymentListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanProductCreateBusinessEvent.class, (BusinessEventListener)new LoanProductCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(SavingsCreateBusinessEvent.class, (BusinessEventListener)new SavingsAccountCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(SavingsCloseBusinessEvent.class, (BusinessEventListener)new SavingsAccountClosedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(ShareAccountCreateBusinessEvent.class, (BusinessEventListener)new ShareAccountCreatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(ShareAccountApproveBusinessEvent.class, (BusinessEventListener)new ShareAccountApprovedListener(this));
    }

    private void buildNotification(String permission, String objectType, Long objectIdentifier, String notificationContent, String eventType, Long appUserId, Long officeId) {
        this.userNotificationService.notifyUsers(permission, objectType, objectIdentifier, notificationContent, eventType, appUserId, officeId);
    }

    @Generated
    public NotificationDomainServiceImpl(BusinessEventNotifierService businessEventNotifierService, PlatformSecurityContext context, UserNotificationService userNotificationService) {
        this.businessEventNotifierService = businessEventNotifierService;
        this.context = context;
        this.userNotificationService = userNotificationService;
    }
}

