/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.fineract.infrastructure.bulkimport.data.BulkImportEvent;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.domain.ImportDocument;
import org.apache.fineract.infrastructure.bulkimport.domain.ImportDocumentRepository;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportEventListener;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.documentmanagement.command.DocumentCommand;
import org.apache.fineract.infrastructure.documentmanagement.domain.Document;
import org.apache.fineract.infrastructure.documentmanagement.service.DocumentWritePlatformService;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class BulkImportEventListener
implements ApplicationListener<BulkImportEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkImportEventListener.class);
    private final ApplicationContext applicationContext;
    private final ImportDocumentRepository importRepository;
    private final DocumentWritePlatformService documentService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(BulkImportEvent event) {
        try {
            ThreadLocalContextUtil.init((FineractContext)event.getContext());
            ImportDocument importDocument = this.importRepository.findById((Object)event.getImportId()).orElse(null);
            GlobalEntityType entityType = GlobalEntityType.fromInt((int)importDocument.getEntityType());
            ImportHandler importHandler = switch (1.$SwitchMap$org$apache$fineract$infrastructure$bulkimport$data$GlobalEntityType[entityType.ordinal()]) {
                case 1 -> (ImportHandler)this.applicationContext.getBean("officeImportHandler", ImportHandler.class);
                case 2 -> (ImportHandler)this.applicationContext.getBean("centerImportHandler", ImportHandler.class);
                case 3 -> (ImportHandler)this.applicationContext.getBean("chartOfAccountsImportHandler", ImportHandler.class);
                case 4 -> (ImportHandler)this.applicationContext.getBean("clientEntityImportHandler", ImportHandler.class);
                case 5 -> (ImportHandler)this.applicationContext.getBean("clientPersonImportHandler", ImportHandler.class);
                case 6 -> (ImportHandler)this.applicationContext.getBean("fixedDepositImportHandler", ImportHandler.class);
                case 7 -> (ImportHandler)this.applicationContext.getBean("fixedDepositTransactionImportHandler", ImportHandler.class);
                case 8 -> (ImportHandler)this.applicationContext.getBean("groupImportHandler", ImportHandler.class);
                case 9 -> (ImportHandler)this.applicationContext.getBean("guarantorImportHandler", ImportHandler.class);
                case 10 -> (ImportHandler)this.applicationContext.getBean("journalEntriesImportHandler", ImportHandler.class);
                case 11 -> (ImportHandler)this.applicationContext.getBean("loanImportHandler", ImportHandler.class);
                case 12 -> (ImportHandler)this.applicationContext.getBean("loanRepaymentImportHandler", ImportHandler.class);
                case 13 -> (ImportHandler)this.applicationContext.getBean("recurringDepositImportHandler", ImportHandler.class);
                case 14 -> (ImportHandler)this.applicationContext.getBean("recurringDepositTransactionImportHandler", ImportHandler.class);
                case 15 -> (ImportHandler)this.applicationContext.getBean("savingsImportHandler", ImportHandler.class);
                case 16 -> (ImportHandler)this.applicationContext.getBean("savingsTransactionImportHandler", ImportHandler.class);
                case 17 -> (ImportHandler)this.applicationContext.getBean("sharedAccountImportHandler", ImportHandler.class);
                case 18 -> (ImportHandler)this.applicationContext.getBean("staffImportHandler", ImportHandler.class);
                case 19 -> (ImportHandler)this.applicationContext.getBean("userImportHandler", ImportHandler.class);
                default -> throw new GeneralPlatformDomainRuleException("error.msg.unable.to.find.resource", "Unable to find requested resource", new Object[0]);
            };
            Workbook workbook = event.getWorkbook();
            Count count = importHandler.process(workbook, event.getLocale(), event.getDateFormat());
            importDocument.update(DateUtils.getLocalDateTimeOfTenant(), count.getSuccessCount(), count.getErrorCount());
            this.importRepository.saveAndFlush((Object)importDocument);
            HashSet<String> modifiedParams = new HashSet<String>();
            modifiedParams.add("fileName");
            modifiedParams.add("size");
            modifiedParams.add("type");
            modifiedParams.add("location");
            Document document = importDocument.getDocument();
            DocumentCommand documentCommand = new DocumentCommand(modifiedParams, (Long)document.getId(), entityType.name(), null, document.getName(), document.getFileName(), document.getSize(), URLConnection.guessContentTypeFromName(document.getFileName()), null, null);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                try {
                    workbook.write((OutputStream)bos);
                }
                finally {
                    bos.close();
                }
            }
            catch (IOException io) {
                log.error("Problem occurred in onApplicationEvent function", (Throwable)io);
            }
            byte[] bytes = bos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            this.documentService.updateDocument(documentCommand, (InputStream)bis);
        }
        finally {
            ThreadLocalContextUtil.reset();
        }
    }

    @Generated
    public BulkImportEventListener(ApplicationContext applicationContext, ImportDocumentRepository importRepository, DocumentWritePlatformService documentService) {
        this.applicationContext = applicationContext;
        this.importRepository = importRepository;
        this.documentService = documentService;
    }
}

