/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationProperty;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationRepositoryWrapper;
import org.apache.fineract.infrastructure.configuration.service.MoneyHelperInitializationService;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"test"})
@Component
@Path(value="/v1/internal/configurations")
public class InternalConfigurationsApiResource
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalConfigurationsApiResource.class);
    private final GlobalConfigurationRepositoryWrapper repository;
    private final MoneyHelperInitializationService moneyHelperInitializationService;

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void afterPropertiesSet() throws Exception {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("Internal Config services mode is enabled");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
    }

    @PUT
    @Path(value="name/{configName}/value/{configValue}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public Response updateGlobalConfiguration(@PathParam(value="configName") String configName, @PathParam(value="configValue") Long configValue) {
        FineractPlatformTenant currentTenant;
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Update trap-door config: {}", (Object)configName);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        GlobalConfigurationProperty config = this.repository.findOneByNameWithNotFoundDetection(configName);
        config.setValue(configValue);
        this.repository.save(config);
        log.warn("Config {} updated to {}", (Object)config.getName(), (Object)config.getValue());
        this.repository.removeFromCache(config.getName());
        if ("rounding-mode".equals(configName) && configValue != null && (currentTenant = ThreadLocalContextUtil.getTenant()) != null) {
            this.moneyHelperInitializationService.initializeTenantRoundingMode(currentTenant);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Generated
    public InternalConfigurationsApiResource(GlobalConfigurationRepositoryWrapper repository, MoneyHelperInitializationService moneyHelperInitializationService) {
        this.repository = repository;
        this.moneyHelperInitializationService = moneyHelperInitializationService;
    }
}

