/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.instancemode.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.data.ApiGlobalErrorResponse;
import org.apache.fineract.infrastructure.instancemode.filter.FineractInstanceModeApiFilter;
import org.springframework.web.filter.OncePerRequestFilter;

public class FineractInstanceModeApiFilter
extends OncePerRequestFilter {
    private static final List<ExceptionListItem> EXCEPTION_LIST = List.of(ExceptionListItem.item(FineractProperties.FineractModeProperties::isBatchManagerEnabled, pi -> pi.startsWith("/v1/jobs")), ExceptionListItem.item(FineractProperties.FineractModeProperties::isBatchManagerEnabled, pi -> pi.startsWith("/v1/scheduler")), ExceptionListItem.item(FineractProperties.FineractModeProperties::isBatchManagerEnabled, pi -> pi.startsWith("/v1/loans/catch-up")), ExceptionListItem.item(FineractProperties.FineractModeProperties::isBatchManagerEnabled, pi -> pi.startsWith("/v1/loans/is-catch-up-running")), ExceptionListItem.item(p -> true, pi -> pi.startsWith("/v1/instance-mode")), ExceptionListItem.item(p -> true, pi -> pi.startsWith("/v1/batches")));
    private final FineractProperties fineractProperties;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.isOnExceptionList(request) || this.isActuatorApi(request)) {
            this.proceed(filterChain, request, response);
        } else if (this.isPathOnExceptionList(request)) {
            this.reject(request, response);
        } else if (this.fineractProperties.getMode().isReadEnabled() && this.isReadMethod(request)) {
            this.proceed(filterChain, request, response);
        } else if (this.fineractProperties.getMode().isWriteEnabled()) {
            this.proceed(filterChain, request, response);
        } else {
            this.reject(request, response);
        }
    }

    private boolean isActuatorApi(HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getServletPath())) {
            return false;
        }
        return request.getServletPath().startsWith("/actuator");
    }

    private void proceed(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void reject(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(405);
        ApiGlobalErrorResponse errorResponse = ApiGlobalErrorResponse.invalidInstanceTypeMethod((String)request.getMethod());
        response.getWriter().write(errorResponse.toJson());
    }

    private boolean isPathOnExceptionList(HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getPathInfo())) {
            return false;
        }
        return EXCEPTION_LIST.stream().anyMatch(item -> (Boolean)item.getPathFunction().apply(request.getPathInfo()));
    }

    private boolean isOnExceptionList(HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getPathInfo())) {
            return false;
        }
        return EXCEPTION_LIST.stream().anyMatch(item -> (Boolean)item.getModeFunction().apply(this.fineractProperties.getMode()) != false && (Boolean)item.getPathFunction().apply(request.getPathInfo()) != false);
    }

    private boolean isReadMethod(HttpServletRequest request) {
        return "GET".equals(request.getMethod());
    }

    @Generated
    public FineractInstanceModeApiFilter(FineractProperties fineractProperties) {
        this.fineractProperties = fineractProperties;
    }
}

