/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.transferinteresttosavings;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.savings.exception.InsufficientAccountBalanceException;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class TransferInterestToSavingsTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransferInterestToSavingsTasklet.class);
    private final DepositAccountReadPlatformService depositAccountReadPlatformService;
    private final AccountTransfersWritePlatformService accountTransfersWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        Collection accountTransferData = this.depositAccountReadPlatformService.retrieveDataForInterestTransfer();
        for (AccountTransferDTO accountTransferDTO : accountTransferData) {
            try {
                this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
            }
            catch (PlatformApiDataValidationException e) {
                log.error("Validation exception while trasfering Interest from {} to {}", new Object[]{accountTransferDTO.getFromAccountId(), accountTransferDTO.getToAccountId(), e});
                errors.add(e);
            }
            catch (InsufficientAccountBalanceException e) {
                log.warn("InsufficientAccountBalanceException while trasfering Interest from {} to {} ", new Object[]{accountTransferDTO.getFromAccountId(), accountTransferDTO.getToAccountId(), e});
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new JobExecutionException(errors);
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public TransferInterestToSavingsTasklet(DepositAccountReadPlatformService depositAccountReadPlatformService, AccountTransfersWritePlatformService accountTransfersWritePlatformService) {
        this.depositAccountReadPlatformService = depositAccountReadPlatformService;
        this.accountTransfersWritePlatformService = accountTransfersWritePlatformService;
    }
}

