/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.data.PaginationParametersDataValidator;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarFrequencyType;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.charge.util.ConvertChargeDataToSpecificChargeData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.common.service.CommonEnumerations;
import org.apache.fineract.portfolio.common.service.DropdownReadPlatformService;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartData;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartReadPlatformService;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountOnClosureType;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.SavingsAccountTransactionType;
import org.apache.fineract.portfolio.savings.data.DepositAccountData;
import org.apache.fineract.portfolio.savings.data.DepositAccountInterestRateChartData;
import org.apache.fineract.portfolio.savings.data.FixedDepositAccountData;
import org.apache.fineract.portfolio.savings.data.RecurringDepositAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.apache.fineract.portfolio.savings.exception.DepositAccountNotFoundException;
import org.apache.fineract.portfolio.savings.service.DepositAccountInterestRateChartReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformServiceImpl;
import org.apache.fineract.portfolio.savings.service.DepositProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositsDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsEnumerations;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class DepositAccountReadPlatformServiceImpl
implements DepositAccountReadPlatformService {
    private static final FixedDepositAccountMapper FIXED_DEPOSIT_ACCOUNT_MAPPER = new FixedDepositAccountMapper();
    private static final RecurringDepositAccountMapper RECURRING_DEPOSIT_ACCOUNT_MAPPER = new RecurringDepositAccountMapper();
    private static final DepositAccountLookupMapper DEPOSIT_ACCOUNT_LOOKUP_MAPPER = new DepositAccountLookupMapper();
    private static final DepositAccountForMaturityMapper DEPOSIT_ACCOUNT_FOR_MATURITY_MAPPER = new DepositAccountForMaturityMapper();
    private static final Set<String> supportedOrderByValues = new HashSet<String>(Arrays.asList("id", "accountNumbr", "officeId", "officeName"));
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final DepositAccountInterestRateChartReadPlatformService accountChartReadPlatformService;
    private final InterestRateChartReadPlatformService productChartReadPlatformService;
    private final PaginationParametersDataValidator paginationParametersDataValidator;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PaginationHelper paginationHelper;
    private final SavingsAccountTransactionsMapper transactionsMapper = new SavingsAccountTransactionsMapper();
    private final ClientReadPlatformService clientReadPlatformService;
    private final GroupReadPlatformService groupReadPlatformService;
    private final DepositProductReadPlatformService depositProductReadPlatformService;
    private final SavingsDropdownReadPlatformService savingsDropdownReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final DepositsDropdownReadPlatformService depositsDropdownReadPlatformService;
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private final RecurringAccountDepositTransactionTemplateMapper rdTransactionTemplateMapper = new RecurringAccountDepositTransactionTemplateMapper();
    private final DropdownReadPlatformService dropdownReadPlatformService;
    private final CalendarReadPlatformService calendarReadPlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;

    public Collection<DepositAccountData> retrieveAll(DepositAccountType depositAccountType, PaginationParameters paginationParameters) {
        this.context.authenticatedUser();
        DepositAccountMapper depositAccountMapper = this.getDepositAccountMapper(depositAccountType);
        if (depositAccountMapper == null) {
            return null;
        }
        StringBuilder sqlBuilder = new StringBuilder(400);
        sqlBuilder.append("select ");
        sqlBuilder.append(depositAccountMapper.schema());
        sqlBuilder.append(" where sa.deposit_type_enum = ? ");
        sqlBuilder.append(paginationParameters.paginationSql());
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)depositAccountMapper, new Object[]{depositAccountType.getValue()});
    }

    public Page<DepositAccountData> retrieveAllPaged(DepositAccountType depositAccountType, PaginationParameters paginationParameters) {
        this.paginationParametersDataValidator.validateParameterValues(paginationParameters, supportedOrderByValues, depositAccountType.resourceName());
        DepositAccountMapper depositAccountMapper = this.getDepositAccountMapper(depositAccountType);
        if (depositAccountMapper == null) {
            return null;
        }
        StringBuilder sqlBuilder = new StringBuilder(400);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(depositAccountMapper.schema());
        sqlBuilder.append(" where sa.deposit_type_enum = ? ");
        sqlBuilder.append(paginationParameters.paginationSql());
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), new Object[]{depositAccountType.getValue()}, (RowMapper)depositAccountMapper);
    }

    public Collection<DepositAccountData> retrieveAllForLookup(DepositAccountType depositAccountType) {
        StringBuilder sqlBuilder = new StringBuilder(400);
        sqlBuilder.append("select ");
        sqlBuilder.append(DEPOSIT_ACCOUNT_LOOKUP_MAPPER.schema());
        sqlBuilder.append(" where sa.deposit_type_enum = ? ");
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)DEPOSIT_ACCOUNT_LOOKUP_MAPPER, new Object[]{depositAccountType.getValue()});
    }

    public Collection<DepositAccountData> retrieveForMaturityUpdate() {
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("SELECT ");
        sqlBuilder.append(DEPOSIT_ACCOUNT_FOR_MATURITY_MAPPER.schema());
        sqlBuilder.append(" WHERE da.deposit_type_enum in (?, ?) and da.status_enum = ?");
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)DEPOSIT_ACCOUNT_FOR_MATURITY_MAPPER, new Object[]{DepositAccountType.FIXED_DEPOSIT.getValue(), DepositAccountType.RECURRING_DEPOSIT.getValue(), SavingsAccountStatusType.ACTIVE.getValue()});
    }

    public DepositAccountData retrieveOne(DepositAccountType depositAccountType, Long accountId) {
        try {
            this.context.authenticatedUser();
            DepositAccountMapper depositAccountMapper = this.getDepositAccountMapper(depositAccountType);
            if (depositAccountMapper == null) {
                return null;
            }
            StringBuilder sqlBuilder = new StringBuilder(400);
            sqlBuilder.append("select ");
            sqlBuilder.append(depositAccountMapper.schema());
            sqlBuilder.append(" where sa.id = ? and sa.deposit_type_enum = ? ");
            return (DepositAccountData)this.jdbcTemplate.queryForObject(sqlBuilder.toString(), (RowMapper)depositAccountMapper, new Object[]{accountId, depositAccountType.getValue()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new DepositAccountNotFoundException(depositAccountType, accountId, e);
        }
    }

    public DepositAccountData retrieveOneWithClosureTemplate(DepositAccountType depositAccountType, Long accountId) {
        try {
            this.context.authenticatedUser();
            DepositAccountMapper depositAccountMapper = this.getDepositAccountMapper(depositAccountType);
            if (depositAccountMapper == null) {
                return null;
            }
            StringBuilder sqlBuilder = new StringBuilder(400);
            sqlBuilder.append("select ");
            sqlBuilder.append(depositAccountMapper.schema());
            sqlBuilder.append(" where sa.id = ? and sa.deposit_type_enum = ? ");
            DepositAccountData account = (DepositAccountData)this.jdbcTemplate.queryForObject(sqlBuilder.toString(), (RowMapper)depositAccountMapper, new Object[]{accountId, depositAccountType.getValue()});
            List onAccountClosureOptions = SavingsEnumerations.depositAccountOnClosureType((DepositAccountOnClosureType[])DepositAccountOnClosureType.values());
            List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
            Collection savingsAccountDatas = this.savingsAccountReadPlatformService.retrieveActiveForLookup(account.getClientId(), DepositAccountType.SAVINGS_DEPOSIT);
            if (depositAccountType.isFixedDeposit()) {
                account = FixedDepositAccountData.withClosureTemplateDetails((FixedDepositAccountData)((FixedDepositAccountData)account), (Collection)onAccountClosureOptions, (Collection)paymentTypeOptions, (Collection)savingsAccountDatas);
            } else if (depositAccountType.isRecurringDeposit()) {
                account = RecurringDepositAccountData.withClosureTemplateDetails((RecurringDepositAccountData)((RecurringDepositAccountData)account), (Collection)onAccountClosureOptions, (Collection)paymentTypeOptions, (Collection)savingsAccountDatas);
            }
            return account;
        }
        catch (EmptyResultDataAccessException e) {
            throw new DepositAccountNotFoundException(depositAccountType, accountId, e);
        }
    }

    public DepositAccountData retrieveOneWithChartSlabs(DepositAccountType depositAccountType, Long accountId) {
        DepositAccountData depositAccount = this.retrieveOne(depositAccountType, accountId);
        DepositAccountInterestRateChartData chart = this.accountChartReadPlatformService.retrieveOneWithSlabsOnAccountId(accountId);
        if (depositAccountType.isFixedDeposit()) {
            depositAccount = FixedDepositAccountData.withInterestChart((FixedDepositAccountData)((FixedDepositAccountData)depositAccount), (DepositAccountInterestRateChartData)chart);
        } else if (depositAccountType.isRecurringDeposit()) {
            CalendarData calendar = this.calendarReadPlatformService.retrieveCollctionCalendarByEntity(accountId, CalendarEntityType.SAVINGS.getValue());
            Integer frequency = calendar.getInterval() == -1 ? 1 : calendar.getInterval();
            CalendarFrequencyType calendarFrequencyType = CalendarFrequencyType.fromInt((int)((Long)calendar.getFrequency().getId()).intValue());
            PeriodFrequencyType periodFrequencyType = CalendarFrequencyType.from((CalendarFrequencyType)calendarFrequencyType);
            EnumOptionData frequencyType = CommonEnumerations.termFrequencyType((PeriodFrequencyType)periodFrequencyType, (String)"recurring.deposit.frequency.");
            depositAccount = RecurringDepositAccountData.withInterestChartAndRecurringDetails((RecurringDepositAccountData)((RecurringDepositAccountData)depositAccount), (DepositAccountInterestRateChartData)chart, (Integer)frequency, (EnumOptionData)frequencyType);
        }
        return depositAccount;
    }

    public Collection<SavingsAccountTransactionData> retrieveAllTransactions(DepositAccountType depositAccountType, Long accountId) {
        String sql = "select " + this.transactionsMapper.schema() + " where sa.id = ? and sa.deposit_type_enum = ? order by tr.transaction_date DESC, tr.id DESC";
        return this.jdbcTemplate.query(sql, (RowMapper)this.transactionsMapper, new Object[]{accountId, depositAccountType.getValue()});
    }

    public DepositAccountData retrieveTemplate(DepositAccountType depositAccountType, Long clientId, Long groupId, Long productId, boolean staffInSelectedOfficeOnly) {
        AppUser loggedInUser = this.context.authenticatedUser();
        Long officeId = (Long)loggedInUser.getOffice().getId();
        ClientData client = null;
        Collection savingsAccountDatas = null;
        if (clientId != null) {
            client = this.clientReadPlatformService.retrieveOne(clientId);
            officeId = client.getOfficeId();
            savingsAccountDatas = this.savingsAccountReadPlatformService.retrieveActiveForLookup(clientId, DepositAccountType.SAVINGS_DEPOSIT);
        }
        GroupGeneralData group = null;
        if (groupId != null) {
            group = this.groupReadPlatformService.retrieveOne(groupId);
            officeId = group.getOfficeId();
        }
        Collection preClosurePenalInterestOnTypeOptions = this.depositsDropdownReadPlatformService.retrievePreClosurePenalInterestOnTypeOptions();
        List periodFrequencyTypeOptions = this.dropdownReadPlatformService.retrievePeriodFrequencyTypeOptions();
        Collection productOptions = this.depositProductReadPlatformService.retrieveAllForLookup(depositAccountType);
        DepositAccountData template = null;
        if (productId != null) {
            DepositAccountTemplateMapper mapper = this.getDepositAccountTemplaMapper(depositAccountType, client, group);
            String sql = "select " + mapper.schema() + " where sa.id = ? and sa.deposit_type_enum = ? ";
            template = (DepositAccountData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{productId, depositAccountType.getValue()});
            Collection interestCompoundingPeriodTypeOptions = this.savingsDropdownReadPlatformService.retrieveCompoundingInterestPeriodTypeOptions();
            Collection interestPostingPeriodTypeOptions = this.savingsDropdownReadPlatformService.retrieveInterestPostingPeriodTypeOptions();
            Collection interestCalculationTypeOptions = this.savingsDropdownReadPlatformService.retrieveInterestCalculationTypeOptions();
            Collection interestCalculationDaysInYearTypeOptions = this.savingsDropdownReadPlatformService.retrieveInterestCalculationDaysInYearTypeOptions();
            Collection lockinPeriodFrequencyTypeOptions = this.savingsDropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
            Collection withdrawalFeeTypeOptions = this.savingsDropdownReadPlatformService.retrievewithdrawalFeeTypeOptions();
            Collection transactions = null;
            List productCharges = this.chargeReadPlatformService.retrieveSavingsProductCharges(productId);
            Collection charges = this.fromChargesToSavingsCharges((Collection)productCharges);
            boolean feeChargesOnly = false;
            List chargeOptions = this.chargeReadPlatformService.retrieveSavingsProductApplicableCharges(false);
            Collection maturityInstructionOptions = this.depositsDropdownReadPlatformService.maturityInstructionOptions();
            ArrayList fieldOfficerOptions = null;
            if (officeId != null) {
                if (staffInSelectedOfficeOnly) {
                    List fieldOfficersInBranch = this.staffReadPlatformService.retrieveAllLoanOfficersInOfficeById(officeId);
                    if (!CollectionUtils.isEmpty((Collection)fieldOfficersInBranch)) {
                        fieldOfficerOptions = new ArrayList(fieldOfficersInBranch);
                    }
                } else {
                    boolean restrictToLoanOfficersOnly = true;
                    List loanOfficersInHierarchy = this.staffReadPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(officeId, true);
                    if (!CollectionUtils.isEmpty((Collection)loanOfficersInHierarchy)) {
                        fieldOfficerOptions = new ArrayList(loanOfficersInHierarchy);
                    }
                }
            }
            InterestRateChartData productChartData = this.productChartReadPlatformService.retrieveActiveChartWithTemplate(productId);
            DepositAccountInterestRateChartData accountChart = DepositAccountInterestRateChartData.from((InterestRateChartData)productChartData);
            if (depositAccountType.isFixedDeposit()) {
                template = FixedDepositAccountData.withTemplateOptions((FixedDepositAccountData)((FixedDepositAccountData)template), (Collection)productOptions, fieldOfficerOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, transactions, (Collection)charges, (Collection)chargeOptions, (Collection)preClosurePenalInterestOnTypeOptions, (Collection)periodFrequencyTypeOptions, (Collection)savingsAccountDatas, (Collection)maturityInstructionOptions);
                template = FixedDepositAccountData.withInterestChart((FixedDepositAccountData)((FixedDepositAccountData)template), (DepositAccountInterestRateChartData)accountChart);
            } else if (depositAccountType.isRecurringDeposit()) {
                template = RecurringDepositAccountData.withTemplateOptions((RecurringDepositAccountData)((RecurringDepositAccountData)template), (Collection)productOptions, fieldOfficerOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, transactions, (Collection)charges, (Collection)chargeOptions, (Collection)preClosurePenalInterestOnTypeOptions, (Collection)periodFrequencyTypeOptions);
                template = RecurringDepositAccountData.withInterestChartAndRecurringDetails((RecurringDepositAccountData)((RecurringDepositAccountData)template), (DepositAccountInterestRateChartData)accountChart, null, null);
            }
        } else {
            String clientName = null;
            if (client != null) {
                clientName = client.getDisplayName();
            }
            String groupName = null;
            if (group != null) {
                groupName = group.getName();
            }
            Collection fieldOfficerOptions = null;
            Collection interestCompoundingPeriodTypeOptions = null;
            Collection interestPostingPeriodTypeOptions = null;
            Collection interestCalculationTypeOptions = null;
            Collection interestCalculationDaysInYearTypeOptions = null;
            Collection lockinPeriodFrequencyTypeOptions = null;
            Collection withdrawalFeeTypeOptions = null;
            Collection transactions = null;
            Collection charges = null;
            Collection maturityInstructionOptions = null;
            boolean feeChargesOnly = true;
            List chargeOptions = this.chargeReadPlatformService.retrieveSavingsProductApplicableCharges(true);
            if (depositAccountType.isFixedDeposit()) {
                template = FixedDepositAccountData.withClientTemplate((Long)clientId, (String)clientName, (Long)groupId, (String)groupName);
                template = FixedDepositAccountData.withTemplateOptions((FixedDepositAccountData)((FixedDepositAccountData)template), (Collection)productOptions, fieldOfficerOptions, interestCompoundingPeriodTypeOptions, interestPostingPeriodTypeOptions, interestCalculationTypeOptions, interestCalculationDaysInYearTypeOptions, lockinPeriodFrequencyTypeOptions, withdrawalFeeTypeOptions, transactions, charges, (Collection)chargeOptions, (Collection)preClosurePenalInterestOnTypeOptions, (Collection)periodFrequencyTypeOptions, (Collection)savingsAccountDatas, maturityInstructionOptions);
            } else if (depositAccountType.isRecurringDeposit()) {
                template = RecurringDepositAccountData.withClientTemplate((Long)clientId, (String)clientName, (Long)groupId, (String)groupName);
                template = RecurringDepositAccountData.withTemplateOptions((RecurringDepositAccountData)((RecurringDepositAccountData)template), (Collection)productOptions, fieldOfficerOptions, interestCompoundingPeriodTypeOptions, interestPostingPeriodTypeOptions, interestCalculationTypeOptions, interestCalculationDaysInYearTypeOptions, lockinPeriodFrequencyTypeOptions, withdrawalFeeTypeOptions, transactions, charges, (Collection)chargeOptions, (Collection)preClosurePenalInterestOnTypeOptions, (Collection)periodFrequencyTypeOptions);
            }
        }
        return template;
    }

    public SavingsAccountTransactionData retrieveRecurringAccountDepositTransactionTemplate(Long accountId) {
        try {
            String sql = "select " + this.rdTransactionTemplateMapper.schema() + " where sa.id = ? and sa.deposit_type_enum = ? order by mss.installment limit 1";
            return (SavingsAccountTransactionData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.rdTransactionTemplateMapper, new Object[]{accountId, accountId, DepositAccountType.RECURRING_DEPOSIT.getValue()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new DepositAccountNotFoundException(DepositAccountType.RECURRING_DEPOSIT, accountId, e);
        }
    }

    public Collection<AccountTransferDTO> retrieveDataForInterestTransfer() {
        StringBuilder sqlBuilder = new StringBuilder(300);
        AccountTransferMapper mapper = new AccountTransferMapper();
        sqlBuilder.append("SELECT ");
        sqlBuilder.append(mapper.schema());
        sqlBuilder.append(" where da.transfer_interest_to_linked_account = true and ");
        sqlBuilder.append("st.transaction_date > (select coalesce(max(sat.transaction_date),sa.activatedon_date) from m_savings_account_transaction sat where sat.transaction_type_enum = ? and sat.savings_account_id = sa.id and sat.is_reversed=false) ");
        sqlBuilder.append("and st.transaction_type_enum = ? and sa.status_enum = ? and st.is_reversed=false and st.transaction_date > coalesce(sa.lockedin_until_date_derived,sa.activatedon_date)");
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)mapper, new Object[]{SavingsAccountTransactionType.WITHDRAWAL.getValue(), SavingsAccountTransactionType.INTEREST_POSTING.getValue(), SavingsAccountStatusType.ACTIVE.getValue()});
    }

    public Collection<Map<String, Object>> retriveDataForRDScheduleCreation() {
        String today = DATE_TIME_FORMATTER.format(DateUtils.getBusinessLocalDate());
        StringBuilder sb = new StringBuilder(300);
        sb.append(" select rd.savings_account_id savingsId, rd.mandatory_recommended_deposit_amount as amount,");
        sb.append(" mc.recurrence as recurrence ,");
        sb.append(" max(ms.duedate) as dueDate , max(ms.installment) as installment,");
        sb.append(" count(ms.installment) as futureInstallments");
        sb.append(" from m_deposit_account_term_and_preclosure dat ");
        sb.append(" inner join m_savings_account sa on sa.id = dat.savings_account_id and sa.status_enum = ?");
        sb.append(" inner join m_deposit_account_recurring_detail rd on rd.savings_account_id = dat.savings_account_id ");
        sb.append(" inner join m_calendar_instance mci on mci.entity_type_enum = ? and mci.entity_id = dat.savings_account_id  ");
        sb.append(" inner join m_calendar mc  on mc.id = mci.calendar_id and mc.calendar_type_enum = ?");
        sb.append(" inner join m_mandatory_savings_schedule ms on ms.savings_account_id = dat.savings_account_id and ms.duedate > '" + today + "'");
        sb.append(" where dat.deposit_period is null");
        sb.append(" group by ms.savings_account_id, rd.mandatory_recommended_deposit_amount, mc.recurrence, rd.savings_account_id");
        return this.jdbcTemplate.queryForList(sb.toString(), new Object[]{SavingsAccountStatusType.ACTIVE.getValue(), CalendarEntityType.SAVINGS.getValue(), CalendarType.COLLECTION.getValue()});
    }

    private DepositAccountMapper getDepositAccountMapper(DepositAccountType depositAccountType) {
        if (depositAccountType.isFixedDeposit()) {
            return FIXED_DEPOSIT_ACCOUNT_MAPPER;
        }
        if (depositAccountType.isRecurringDeposit()) {
            return RECURRING_DEPOSIT_ACCOUNT_MAPPER;
        }
        return null;
    }

    private DepositAccountTemplateMapper getDepositAccountTemplaMapper(DepositAccountType depositAccountType, ClientData client, GroupGeneralData group) {
        if (depositAccountType.isFixedDeposit()) {
            return new FixedDepositAccountTemplateMapper(client, group);
        }
        if (depositAccountType.isRecurringDeposit()) {
            return new RecurringDepositAccountTemplateMapper(client, group);
        }
        return null;
    }

    private Collection<SavingsAccountChargeData> fromChargesToSavingsCharges(Collection<ChargeData> productCharges) {
        ArrayList<SavingsAccountChargeData> savingsCharges = new ArrayList<SavingsAccountChargeData>();
        for (ChargeData chargeData : productCharges) {
            SavingsAccountChargeData savingsCharge = ConvertChargeDataToSpecificChargeData.toSavingsAccountChargeData((ChargeData)chargeData);
            savingsCharges.add(savingsCharge);
        }
        return savingsCharges;
    }

    @Generated
    public DepositAccountReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, DepositAccountInterestRateChartReadPlatformService accountChartReadPlatformService, InterestRateChartReadPlatformService productChartReadPlatformService, PaginationParametersDataValidator paginationParametersDataValidator, DatabaseSpecificSQLGenerator sqlGenerator, PaginationHelper paginationHelper, ClientReadPlatformService clientReadPlatformService, GroupReadPlatformService groupReadPlatformService, DepositProductReadPlatformService depositProductReadPlatformService, SavingsDropdownReadPlatformService savingsDropdownReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, StaffReadPlatformService staffReadPlatformService, DepositsDropdownReadPlatformService depositsDropdownReadPlatformService, SavingsAccountReadPlatformService savingsAccountReadPlatformService, DropdownReadPlatformService dropdownReadPlatformService, CalendarReadPlatformService calendarReadPlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.accountChartReadPlatformService = accountChartReadPlatformService;
        this.productChartReadPlatformService = productChartReadPlatformService;
        this.paginationParametersDataValidator = paginationParametersDataValidator;
        this.sqlGenerator = sqlGenerator;
        this.paginationHelper = paginationHelper;
        this.clientReadPlatformService = clientReadPlatformService;
        this.groupReadPlatformService = groupReadPlatformService;
        this.depositProductReadPlatformService = depositProductReadPlatformService;
        this.savingsDropdownReadPlatformService = savingsDropdownReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.depositsDropdownReadPlatformService = depositsDropdownReadPlatformService;
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.calendarReadPlatformService = calendarReadPlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
    }
}

