/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Gets or Sets TransactionType
 */
@JsonAdapter(TransactionType.Adapter.class)
public enum TransactionType {
  
  DISBURSEMENT("disbursement"),
  
  REPAYMENT("repayment"),
  
  WAIVER("waiver"),
  
  REPAYMENT_AT_DISBURSEMENT("repaymentAtDisbursement"),
  
  WRITE_OFF("writeOff"),
  
  MARKED_FOR_RESCHEDULING("markedForRescheduling"),
  
  RECOVERY_REPAYMENT("recoveryRepayment"),
  
  WAIVE_CHARGES("waiveCharges"),
  
  ACCRUAL("accrual"),
  
  INITIATE_TRANSFER("initiateTransfer"),
  
  APPROVE_TRANSFER("approveTransfer"),
  
  WITHDRAW_TRANSFER("withdrawTransfer"),
  
  REJECT_TRANSFER("rejectTransfer"),
  
  REFUND("refund"),
  
  CHARGE_PAYMENT("chargePayment"),
  
  INCOME_POSTING("incomePosting"),
  
  CREDIT_BALANCE_REFUND("creditBalanceRefund"),
  
  MERCHANT_ISSUED_REFUND("merchantIssuedRefund"),
  
  PAYOUT_REFUND("payoutRefund"),
  
  GOODWILL_CREDIT("goodwillCredit"),
  
  CHARGE_REFUND("chargeRefund"),
  
  CHARGEBACK("chargeback"),
  
  CHARGE_ADJUSTMENT("chargeAdjustment"),
  
  CHARGE_OFF("chargeOff"),
  
  DOWN_PAYMENT("downPayment"),
  
  RE_AGE("reAge"),
  
  RE_AMORTIZE("reAmortize"),
  
  INTEREST_PAYMENT_WAIVER("interestPaymentWaiver"),
  
  ACCRUAL_ACTIVITY("accrualActivity"),
  
  INTEREST_REFUND("interestRefund"),
  
  ACCRUAL_ADJUSTMENT("accrualAdjustment"),
  
  CAPITALIZED_INCOME("capitalizedIncome"),
  
  CAPITALIZED_INCOME_AMORTIZATION("capitalizedIncomeAmortization"),
  
  CAPITALIZED_INCOME_ADJUSTMENT("capitalizedIncomeAdjustment"),
  
  CONTRACT_TERMINATION("contractTermination"),
  
  CAPITALIZED_INCOME_AMORTIZATION_ADJUSTMENT("capitalizedIncomeAmortizationAdjustment"),
  
  BUY_DOWN_FEE_AMORTIZATION("buyDownFeeAmortization"),
  
  BUY_DOWN_FEE_AMORTIZATION_ADJUSTMENT("buyDownFeeAmortizationAdjustment");

  private String value;

  TransactionType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static TransactionType fromValue(String value) {
    for (TransactionType b : TransactionType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }

  public static class Adapter extends TypeAdapter<TransactionType> {
    @Override
    public void write(final JsonWriter jsonWriter, final TransactionType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public TransactionType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return TransactionType.fromValue(value);
    }
  }
}

