/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.PatchFailedException;
import java.util.List;
import java.util.Objects;

public final class ChangeDelta<T>
extends AbstractDelta<T> {
    public ChangeDelta(Chunk<T> source, Chunk<T> target) {
        super(DeltaType.CHANGE, source, target);
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(target, "target must not be null");
    }

    @Override
    protected void applyTo(List<T> target) throws PatchFailedException {
        int i2;
        int position = this.getSource().getPosition();
        int size = this.getSource().size();
        for (i2 = 0; i2 < size; ++i2) {
            target.remove(position);
        }
        i2 = 0;
        for (Object line : this.getTarget().getLines()) {
            target.add(position + i2, line);
            ++i2;
        }
    }

    @Override
    protected void restore(List<T> target) {
        int i2;
        int position = this.getTarget().getPosition();
        int size = this.getTarget().size();
        for (i2 = 0; i2 < size; ++i2) {
            target.remove(position);
        }
        i2 = 0;
        for (Object line : this.getSource().getLines()) {
            target.add(position + i2, line);
            ++i2;
        }
    }

    @Override
    protected void applyFuzzyToAt(List<T> target, int fuzz, int position) throws PatchFailedException {
        int i2;
        int size = this.getSource().size();
        for (i2 = fuzz; i2 < size - fuzz; ++i2) {
            target.remove(position + fuzz);
        }
        i2 = fuzz;
        for (Object line : this.getTarget().getLines().subList(fuzz, this.getTarget().size() - fuzz)) {
            target.add(position + i2, line);
            ++i2;
        }
    }

    public String toString() {
        return "[ChangeDelta, position: " + this.getSource().getPosition() + ", lines: " + this.getSource().getLines() + " to " + this.getTarget().getLines() + "]";
    }

    @Override
    public AbstractDelta<T> withChunks(Chunk<T> original, Chunk<T> revised) {
        return new ChangeDelta<T>(original, revised);
    }
}

