/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.gradle;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.OrderUtil;
import java.util.Comparator;
import java.util.Objects;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.dependencies.DependencyCoordinate;
import org.grails.forge.build.gradle.GradleConfiguration;
import org.grails.forge.options.Language;
import org.grails.forge.template.Writable;

public class GradleDependency
extends DependencyCoordinate {
    public static final Comparator<GradleDependency> COMPARATOR = (o1, o2) -> {
        int comparison = OrderUtil.COMPARATOR.compare(o1, o2);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Integer.compare(o1.getConfiguration().getOrder(), o2.getConfiguration().getOrder());
        if (comparison != 0) {
            return comparison;
        }
        return Coordinate.COMPARATOR.compare((Coordinate)o1, (Coordinate)o2);
    };
    private final Writable extension;
    @NonNull
    private final GradleConfiguration gradleConfiguration;

    public GradleDependency(@NonNull Dependency dependency, @NonNull GeneratorContext generatorContext) {
        this(dependency, generatorContext, null);
    }

    public GradleDependency(@NonNull Dependency dependency, @NonNull GeneratorContext generatorContext, @Nullable Writable extension) {
        super(dependency);
        this.gradleConfiguration = GradleConfiguration.of(dependency.getScope(), Language.DEFAULT_OPTION, generatorContext.getTestFramework()).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot map the dependency scope: [%s] to a Gradle specific scope", dependency.getScope())));
        this.extension = extension;
    }

    @NonNull
    public GradleConfiguration getConfiguration() {
        return this.gradleConfiguration;
    }

    public Writable getExtension() {
        return this.extension;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GradleDependency that = (GradleDependency)o;
        return Objects.equals(this.gradleConfiguration, that.gradleConfiguration);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.gradleConfiguration.hashCode();
        return result;
    }

    @NonNull
    public String toSnippet() {
        String optionalSpace = this.gradleConfiguration == GradleConfiguration.INTEGRATION_TEST_IMPLEMENTATION_TEST_FIXTURES ? "" : " ";
        String snippet = this.gradleConfiguration.getConfigurationName() + optionalSpace;
        if (this.isPom()) {
            snippet = snippet + "platform(";
        } else if (this.gradleConfiguration == GradleConfiguration.INTEGRATION_TEST_IMPLEMENTATION_TEST_FIXTURES) {
            snippet = snippet + "(";
        }
        snippet = snippet + "\"" + this.getGroupId() + ":" + this.getArtifactId() + (String)(this.getVersion() != null ? ":" + this.getVersion() : "") + "\"";
        if (this.isPom() || this.gradleConfiguration == GradleConfiguration.INTEGRATION_TEST_IMPLEMENTATION_TEST_FIXTURES) {
            snippet = snippet + ")";
        }
        if (this.getArtifactId() == "spring-boot-devtools") {
            snippet = snippet + " // Spring Boot DevTools may cause performance slowdowns or compatibility issues on larger applications";
        }
        return snippet;
    }
}

