/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools.layer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.Layers;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.layer.ContentSelector;
import org.springframework.util.Assert;

public class CustomLayers
implements Layers {
    private final List<Layer> layers;
    private final List<ContentSelector<String>> applicationSelectors;
    private final List<ContentSelector<Library>> librarySelectors;

    public CustomLayers(List<Layer> layers, List<ContentSelector<String>> applicationSelectors, List<ContentSelector<Library>> librarySelectors) {
        Assert.notNull(layers, "'layers' must not be null");
        Assert.notNull(applicationSelectors, "'applicationSelectors' must not be null");
        CustomLayers.validateSelectorLayers(applicationSelectors, layers);
        Assert.notNull(librarySelectors, "'librarySelectors' must not be null");
        CustomLayers.validateSelectorLayers(librarySelectors, layers);
        this.layers = new ArrayList<Layer>(layers);
        this.applicationSelectors = new ArrayList(applicationSelectors);
        this.librarySelectors = new ArrayList(librarySelectors);
    }

    private static <T> void validateSelectorLayers(List<ContentSelector<T>> selectors, List<Layer> layers) {
        for (ContentSelector<T> selector : selectors) {
            CustomLayers.validateSelectorLayers(selector, layers);
        }
    }

    private static void validateSelectorLayers(ContentSelector<?> selector, List<Layer> layers) {
        Layer layer = selector.getLayer();
        Assert.state(layer != null, "Missing content selector layer");
        Assert.state(layers.contains(layer), () -> "Content selector layer '" + String.valueOf(selector.getLayer()) + "' not found in " + String.valueOf(layers));
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.layers.iterator();
    }

    @Override
    public Stream<Layer> stream() {
        return this.layers.stream();
    }

    @Override
    public Layer getLayer(String resourceName) {
        return this.selectLayer(resourceName, this.applicationSelectors, () -> "Resource '" + resourceName + "'");
    }

    @Override
    public Layer getLayer(Library library) {
        return this.selectLayer(library, this.librarySelectors, () -> "Library '" + library.getName() + "'");
    }

    private <T> Layer selectLayer(T item, List<ContentSelector<T>> selectors, Supplier<String> name) {
        for (ContentSelector<T> selector : selectors) {
            if (!selector.contains(item)) continue;
            return selector.getLayer();
        }
        throw new IllegalStateException(name.get() + " did not match any layer");
    }
}

