/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.gravitino.cli.KerberosData;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.OAuthData;

public class GravitinoConfig {
    private static String defaultFile = ".gravitino";
    private final String configFile;
    private String metalake;
    private String url;
    private boolean ignore;
    private String authType;
    private OAuthData oauth;
    private KerberosData kerberos;

    public GravitinoConfig(String file) {
        this.configFile = file == null ? System.getProperty("user.home") + "/" + defaultFile : file;
    }

    public boolean fileExists() {
        File file = new File(this.configFile);
        return file.exists();
    }

    public void read() {
        String metalakeKey = "metalake";
        String urlKey = "URL";
        String ignoreKey = "ignore";
        String authKey = "auth";
        Properties prop = new Properties();
        try (FileInputStream stream = new FileInputStream(this.configFile);){
            prop.load(stream);
        }
        catch (FileNotFoundException ex) {
            return;
        }
        catch (IOException exp) {
            System.err.println(exp.getMessage());
            Main.exit(-1);
        }
        if (prop.containsKey(metalakeKey)) {
            this.metalake = prop.getProperty(metalakeKey);
        }
        if (prop.containsKey(urlKey)) {
            this.url = prop.getProperty(urlKey);
        }
        if (prop.containsKey(ignoreKey)) {
            this.ignore = prop.getProperty(ignoreKey).equals("true");
        }
        if (prop.containsKey(authKey)) {
            this.authType = prop.getProperty(authKey);
        }
        if ("oauth".equals(this.authType)) {
            this.oauth = new OAuthData(prop.getProperty("serverURI"), prop.getProperty("credential"), prop.getProperty("token"), prop.getProperty("scope"));
        } else if ("kerberos".equals(this.authType)) {
            this.kerberos = new KerberosData(prop.getProperty("principal"), prop.getProperty("keytabFile"));
        }
    }

    public String getMetalakeName() {
        return this.metalake;
    }

    public String getGravitinoURL() {
        return this.url;
    }

    public boolean getIgnore() {
        return this.ignore;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getGravitinoAuthType() {
        return this.authType;
    }

    public OAuthData getOAuth() {
        return this.oauth;
    }

    public KerberosData getKerberos() {
        return this.kerberos;
    }
}

