/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.gravitino.cli.DefaultConverter;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.ParseType;
import org.apache.gravitino.rel.Column;

public class ReadTableCSV {
    public Column[] columns(Map<String, List<String>> tableData) {
        List<String> names = tableData.get(ExpectedColumns.NAME.getName());
        List<String> datatypes = tableData.get(ExpectedColumns.DATATYPE.getName());
        List<String> comments = tableData.get(ExpectedColumns.COMMENT.getName());
        List<String> nullables = tableData.get(ExpectedColumns.NULLABLE.getName());
        List<String> autoIncs = tableData.get(ExpectedColumns.AUTOINCREMENT.getName());
        List<String> defaultTypes = tableData.get(ExpectedColumns.DEFAULTTYPE.getName());
        List<String> defaulValues = tableData.get(ExpectedColumns.DEFAULTVALUE.getName());
        int size = names.size();
        Column[] columns = new Column[size];
        for (int i = 0; i < size; ++i) {
            String columnName = names.get(i);
            String datatype = datatypes.get(i);
            String comment = comments.get(i);
            boolean nullable = nullables.get(i).equals("true");
            boolean auto = autoIncs.get(i).equals("true");
            String defaultValue = defaulValues.get(i);
            String defaultType = defaultTypes.get(i);
            if (defaultType == null || defaultType.isEmpty()) {
                defaultType = datatype;
            }
            Column.ColumnImpl column = Column.of(columnName, ParseType.toType(datatype), comment, nullable, auto, DefaultConverter.convert(defaultValue, defaultType));
            columns[i] = column;
        }
        return columns;
    }

    public Map<String, List<String>> parse(String csvFile) {
        HashMap<String, List<String>> tableData = new HashMap<String, List<String>>();
        for (ExpectedColumns column : ExpectedColumns.values()) {
            tableData.put(column.getName(), new ArrayList());
        }
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(csvFile, new String[0]), StandardCharsets.UTF_8);){
            CSVParser csvParser = new CSVParser(reader, CSVFormat.Builder.create().setHeader((String[])Arrays.stream(ExpectedColumns.values()).map(ExpectedColumns::getName).toArray(String[]::new)).setIgnoreHeaderCase(true).setSkipHeaderRecord(true).setTrim(true).setIgnoreEmptyLines(true).build());
            for (CSVRecord cvsRecord : csvParser) {
                String defaultValue = null;
                String value = null;
                for (ExpectedColumns column : ExpectedColumns.values()) {
                    switch (column) {
                        case NULLABLE: {
                            defaultValue = "true";
                            break;
                        }
                        case AUTOINCREMENT: {
                            defaultValue = "false";
                            break;
                        }
                        default: {
                            defaultValue = null;
                        }
                    }
                    try {
                        value = cvsRecord.get(column.getName());
                    }
                    catch (IllegalArgumentException exp) {
                        value = defaultValue;
                    }
                    tableData.get(column.getName()).add(value);
                }
            }
        }
        catch (IOException exp) {
            System.err.println(exp.getMessage());
            Main.exit(-1);
        }
        return tableData;
    }

    private static enum ExpectedColumns {
        NAME("Name"),
        DATATYPE("Datatype"),
        COMMENT("Comment"),
        NULLABLE("Nullable"),
        AUTOINCREMENT("AutoIncrement"),
        DEFAULTVALUE("DefaultValue"),
        DEFAULTTYPE("DefaultType");

        private final String name;

        private ExpectedColumns(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

