/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchTagException;

public class DeleteTag
extends Command {
    protected final String metalake;
    protected final String[] tags;
    protected final boolean force;

    public DeleteTag(CommandContext context, String metalake, String[] tags) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
        this.tags = tags;
    }

    @Override
    public void handle() {
        if (!AreYouSure.really(this.force)) {
            return;
        }
        if (this.tags == null || this.tags.length == 0) {
            this.exitWithError("Missing --tag option.");
        } else {
            boolean hasOnlyOneTag;
            boolean bl = hasOnlyOneTag = this.tags.length == 1;
            if (hasOnlyOneTag) {
                this.handleOnlyOneTag();
            } else {
                this.handleMultipleTags();
            }
        }
    }

    private void handleMultipleTags() {
        ArrayList<String> deleted = new ArrayList<String>();
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            for (String tag : this.tags) {
                if (!client.deleteTag(tag)) continue;
                deleted.add(tag);
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchTagException err) {
            this.exitWithError("Unknown tag.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (!deleted.isEmpty()) {
            this.printInformation("Tags " + String.join((CharSequence)",", deleted) + " deleted.");
        }
        if (deleted.size() < this.tags.length) {
            List<String> remaining = Arrays.asList(this.tags);
            remaining.removeAll(deleted);
            this.printInformation("Tags " + String.join((CharSequence)",", remaining) + " not deleted.");
        }
    }

    private void handleOnlyOneTag() {
        boolean deleted = false;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            deleted = client.deleteTag(this.tags[0]);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchTagException err) {
            this.exitWithError("Unknown tag.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (deleted) {
            this.printInformation("Tag " + this.tags[0] + " deleted.");
        } else {
            this.printInformation("Tag " + this.tags[0] + " not deleted.");
        }
    }

    @Override
    public Command validate() {
        if (this.tags == null) {
            this.exitWithError("Missing --tag option.");
        }
        return super.validate();
    }
}

