/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.stats;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.stats.StatisticValue;

public class StatisticValues {
    private StatisticValues() {
    }

    public static BooleanValue booleanValue(boolean value) {
        return new BooleanValue(value);
    }

    public static LongValue longValue(long value) {
        return new LongValue(value);
    }

    public static DoubleValue doubleValue(double value) {
        return new DoubleValue(value);
    }

    public static StringValue stringValue(String value) {
        return new StringValue(value);
    }

    public static <T> ListValue<T> listValue(List<StatisticValue<T>> values) {
        return new ListValue<T>(values);
    }

    public static ObjectValue objectValue(Map<String, StatisticValue<?>> values) {
        return new ObjectValue(values);
    }

    public static class BooleanValue
    implements StatisticValue<Boolean> {
        private final Boolean value;

        private BooleanValue(Boolean value) {
            this.value = value;
        }

        @Override
        public Boolean value() {
            return this.value;
        }

        @Override
        public Type dataType() {
            return Types.BooleanType.get();
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BooleanValue)) {
                return false;
            }
            return Objects.equals(this.value, ((BooleanValue)obj).value());
        }
    }

    public static class LongValue
    implements StatisticValue<Long> {
        private final Long value;

        private LongValue(Long value) {
            this.value = value;
        }

        @Override
        public Long value() {
            return this.value;
        }

        @Override
        public Type dataType() {
            return Types.LongType.get();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LongValue)) {
                return false;
            }
            return Objects.equals(this.value, ((LongValue)obj).value());
        }
    }

    public static class DoubleValue
    implements StatisticValue<Double> {
        private final Double value;

        private DoubleValue(Double value) {
            this.value = value;
        }

        @Override
        public Double value() {
            return this.value;
        }

        @Override
        public Type dataType() {
            return Types.DoubleType.get();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DoubleValue)) {
                return false;
            }
            return Objects.equals(this.value, ((DoubleValue)obj).value());
        }
    }

    public static class StringValue
    implements StatisticValue<String> {
        private final String value;

        private StringValue(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Type dataType() {
            return Types.StringType.get();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StringValue)) {
                return false;
            }
            return Objects.equals(this.value, ((StringValue)obj).value());
        }
    }

    public static class ListValue<T>
    implements StatisticValue<List<StatisticValue<T>>> {
        private final List<StatisticValue<T>> valueList;

        private ListValue(List<StatisticValue<T>> valueList) {
            Preconditions.checkArgument(valueList != null && !valueList.isEmpty(), "Values cannot be null or empty");
            Type dataType = valueList.get(0).dataType();
            Preconditions.checkArgument(valueList.stream().allMatch(value -> value.dataType().equals(dataType)), "All values in the list must have the same data type");
            this.valueList = valueList;
        }

        @Override
        public List<StatisticValue<T>> value() {
            return this.valueList;
        }

        @Override
        public Type dataType() {
            return Types.ListType.nullable(this.valueList.get(0).dataType());
        }

        public int hashCode() {
            return Objects.hash(this.valueList);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ListValue)) {
                return false;
            }
            return Objects.equals(this.valueList, ((ListValue)obj).value());
        }
    }

    public static class ObjectValue
    implements StatisticValue<Map<String, StatisticValue<?>>> {
        private final Map<String, StatisticValue<?>> valueMap;

        private ObjectValue(Map<String, StatisticValue<?>> valueMap) {
            Preconditions.checkArgument(valueMap != null && !valueMap.isEmpty(), "Values cannot be null or empty");
            this.valueMap = valueMap instanceof TreeMap ? valueMap : new TreeMap(valueMap);
        }

        @Override
        public Map<String, StatisticValue<?>> value() {
            return this.valueMap;
        }

        @Override
        public Type dataType() {
            return Types.StructType.of((Types.StructType.Field[])this.valueMap.entrySet().stream().map(entry -> Types.StructType.Field.nullableField((String)entry.getKey(), ((StatisticValue)entry.getValue()).dataType())).toArray(Types.StructType.Field[]::new));
        }

        public int hashCode() {
            return Objects.hash(this.valueMap);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectValue)) {
                return false;
            }
            return Objects.equals(this.valueMap, ((ObjectValue)obj).value());
        }
    }
}

