/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.starrocks.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.distributions.Strategy;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.partitions.ListPartition;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.rel.partitions.Partitions;
import org.apache.gravitino.rel.partitions.RangePartition;
import org.apache.gravitino.rel.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarRocksUtils.class);
    private static final Pattern PARTITION_INFO_PATTERN = Pattern.compile("PARTITION BY \\b(LIST|RANGE)\\b\\((.+)\\)\\s*\\(?");
    private static final Pattern DISTRIBUTION_INFO_PATTERN = Pattern.compile("DISTRIBUTED BY\\s+(HASH|RANDOM)\\s*(\\(([^)]+)\\))?\\s*(BUCKETS\\s+(\\d+))?");
    private static final Pattern TABLE_COMMENT_PATTERN = Pattern.compile("COMMENT\\s*\"([^\\(]+?)\\s*\\(From Gravitino,.*\\)\"");
    private static final String PARTITION_TYPE_VALUE_PATTERN_STRING = "types: \\[([^\\]]+)\\]; keys: \\[([^\\]]+)\\];";
    private static final Pattern PARTITION_TYPE_VALUE_PATTERN = Pattern.compile("types: \\[([^\\]]+)\\]; keys: \\[([^\\]]+)\\];");
    private static final Pattern PARTITION_LIST_PATTERN = Pattern.compile("\\[([^\\[\\]]+)\\]");
    private static final Pattern PARTITION_LIST_PATTERN2 = Pattern.compile("\\(([^()]+)\\)");
    private static final String LIST_PARTITION = "LIST";
    private static final String RANGE_PARTITION = "RANGE";
    public static final String ID = "PartitionId";
    public static final String NAME = "PartitionName";
    public static final String KEY = "PartitionKey";
    public static final String VALUES_LIST = "List";
    public static final String VALUES_RANGE = "Range";
    public static final String VISIBLE_VERSION = "VisibleVersion";
    public static final String VISIBLE_VERSION_TIME = "VisibleVersionTime";
    public static final String STATE = "State";
    public static final String DATA_SIZE = "DataSize";
    public static final String IS_IN_MEMORY = "IsInMemory";

    public static String generatePropertiesSql(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return "";
        }
        StringBuilder sqlBuilder = new StringBuilder(" PROPERTIES (\n");
        sqlBuilder.append(properties.entrySet().stream().map(entry -> "\"" + (String)entry.getKey() + "\"=\"" + (String)entry.getValue() + "\"").collect(Collectors.joining(",\n")));
        sqlBuilder.append("\n)");
        return sqlBuilder.toString();
    }

    public static Map<String, String> extractPropertiesFromSql(String createTableSql) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String[] lines = createTableSql.split("\n");
        boolean isProperties = false;
        String sProperties = "\"(.*)\"\\s*=\\s*\"(.*)\",?";
        Pattern patternProperties = Pattern.compile("\"(.*)\"\\s*=\\s*\"(.*)\",?");
        for (String line : lines) {
            Matcher matcherProperties;
            if (line.contains("PROPERTIES")) {
                isProperties = true;
            }
            if (!isProperties || !(matcherProperties = patternProperties.matcher(line)).find()) continue;
            String key = matcherProperties.group(1).trim();
            String value = matcherProperties.group(2).trim();
            properties.put(key, value);
        }
        return properties;
    }

    /*
     * Exception decompiling
     */
    public static Optional<Transform> extractPartitionInfoFromSql(String createTableSql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Distribution extractDistributionInfoFromSql(String createTableSql) {
        Matcher matcher = DISTRIBUTION_INFO_PATTERN.matcher(createTableSql.trim());
        if (matcher.find()) {
            String distributionType = matcher.group(1);
            String distributionColumns = matcher.group(3);
            String[] columns = Objects.equals(distributionColumns, null) ? new String[]{} : (String[])Arrays.stream(distributionColumns.split(",")).map(String::trim).map(f -> f.substring(1, f.length() - 1)).toArray(String[]::new);
            int bucketNum = StarRocksUtils.extractBucketNum(matcher);
            return new Distributions.DistributionImpl.Builder().withStrategy(Strategy.getByName((String)distributionType)).withNumber(bucketNum).withExpressions((Expression[])Arrays.stream(columns).map(col -> NamedReference.field((String[])new String[]{col})).toArray(NamedReference[]::new)).build();
        }
        throw new RuntimeException("Failed to extract distribution info in sql:" + createTableSql);
    }

    public static String extractTableCommentFromSql(String createTableSql) {
        Matcher matcher = TABLE_COMMENT_PATTERN.matcher(createTableSql.trim());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String generatePartitionSqlFragment(Partition partition) {
        String partitionSqlFragment = "PARTITION `%s` VALUES %s";
        if (partition instanceof RangePartition) {
            return String.format(partitionSqlFragment, partition.name(), StarRocksUtils.generateRangePartitionValues((RangePartition)partition));
        }
        if (partition instanceof ListPartition) {
            return String.format(partitionSqlFragment, partition.name(), StarRocksUtils.generateListPartitionSqlValues((ListPartition)partition));
        }
        throw new IllegalArgumentException("Unsupported partition type of StarRocks");
    }

    private static String generateRangePartitionValues(RangePartition rangePartition) {
        Literal upper = rangePartition.upper();
        String partitionValues = Literals.NULL.equals(upper) ? "LESS THAN MAXVALUE" : String.format("LESS THAN (\"%s\")", upper.value());
        return partitionValues;
    }

    private static String generateListPartitionSqlValues(ListPartition listPartition) {
        Literal[][] lists = listPartition.lists();
        ImmutableList.Builder listValues = ImmutableList.builder();
        for (Literal[] part : lists) {
            String values = part.length > 1 ? String.format("(%s)", Arrays.stream(part).map(p -> "\"" + String.valueOf(p.value()) + "\"").collect(Collectors.joining(","))) : String.format("\"%s\"", part[0].value());
            listValues.add((Object)values);
        }
        return String.format("IN (%s)", listValues.build().stream().collect(Collectors.joining(",")));
    }

    private static int extractBucketNum(Matcher matcher) {
        int bucketNum = -1;
        if (matcher.find(5)) {
            String bucketValue = matcher.group(5);
            if (bucketValue == null) {
                return bucketNum;
            }
            bucketNum = Integer.parseInt(bucketValue);
        }
        return bucketNum;
    }

    public static String toBucketNumberString(int number) {
        return String.valueOf(number);
    }

    public static Partition fromStarRocksPartition(String tableName, ResultSet resultSet, Transform partitionInfo, Map<String, Type> columnTypes) throws SQLException {
        String partitionValues;
        String partitionName = resultSet.getString(NAME);
        String partitionKey = resultSet.getString(KEY);
        if (partitionInfo instanceof Transforms.RangeTransform) {
            partitionValues = resultSet.getString(VALUES_RANGE);
        } else if (partitionInfo instanceof Transforms.ListTransform) {
            partitionValues = resultSet.getString(VALUES_LIST);
        } else {
            throw new UnsupportedOperationException(String.format("%s is not a partitioned table", tableName));
        }
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        propertiesBuilder.put((Object)ID, (Object)resultSet.getString(ID));
        propertiesBuilder.put((Object)VISIBLE_VERSION, (Object)resultSet.getString(VISIBLE_VERSION));
        propertiesBuilder.put((Object)VISIBLE_VERSION_TIME, (Object)resultSet.getString(VISIBLE_VERSION_TIME));
        propertiesBuilder.put((Object)STATE, (Object)resultSet.getString(STATE));
        propertiesBuilder.put((Object)KEY, (Object)partitionKey);
        propertiesBuilder.put((Object)DATA_SIZE, (Object)resultSet.getString(DATA_SIZE));
        propertiesBuilder.put((Object)IS_IN_MEMORY, (Object)resultSet.getString(IS_IN_MEMORY));
        ImmutableMap properties = propertiesBuilder.build();
        String[] partitionKeys = partitionKey.split(",");
        if (partitionInfo instanceof Transforms.RangeTransform) {
            if (partitionKeys.length != 1) {
                throw new UnsupportedOperationException("Multi-column range partitioning in StarRocks is not supported yet");
            }
            Type partitionColumnType = columnTypes.get(partitionKeys[0].trim());
            Literal lower = Literals.NULL;
            Literal upper = Literals.NULL;
            Matcher matcher = PARTITION_TYPE_VALUE_PATTERN.matcher(partitionValues);
            if (matcher.find()) {
                String lowerValue = matcher.group(2);
                lower = Literals.of((Object)lowerValue, (Type)partitionColumnType);
                if (matcher.find()) {
                    String upperValue = matcher.group(2);
                    upper = Literals.of((Object)upperValue, (Type)partitionColumnType);
                }
            }
            return Partitions.range((String)partitionName, (Literal)upper, (Literal)lower, (Map)properties);
        }
        if (partitionInfo instanceof Transforms.ListTransform) {
            ImmutableList.Builder lists = ImmutableList.builder();
            if ((partitionValues = partitionValues.trim()).startsWith("(") && partitionValues.endsWith(")")) {
                Matcher matcher = PARTITION_LIST_PATTERN2.matcher(partitionValues);
                while (matcher.find()) {
                    String[] values = matcher.group(1).split(",");
                    ImmutableList.Builder literValues = ImmutableList.builder();
                    for (int i = 0; i < values.length; ++i) {
                        Type partitionColumnType = columnTypes.get(partitionKeys[i].trim());
                        literValues.add((Object)Literals.of((Object)values[i].trim().replace("\"", "").replace("'", ""), (Type)partitionColumnType));
                    }
                    lists.add((Object)((Literal[])literValues.build().toArray((Object[])new Literal[0])));
                }
                return Partitions.list((String)partitionName, (Literal[][])((Literal[][])lists.build().toArray((Object[])new Literal[0][0])), (Map)properties);
            }
            if (partitionValues.startsWith("[") && partitionValues.endsWith("]")) {
                Matcher matcher = PARTITION_LIST_PATTERN.matcher(partitionValues);
                while (matcher.find()) {
                    String[] values = matcher.group(1).split(",");
                    ImmutableList.Builder literValues = ImmutableList.builder();
                    for (int i = 0; i < values.length; ++i) {
                        Type partitionColumnType = columnTypes.get(partitionKeys[i].trim());
                        literValues.add((Object)Literals.of((Object)values[i].replace("\"", ""), (Type)partitionColumnType));
                    }
                    lists.add((Object)((Literal[])literValues.build().toArray((Object[])new Literal[0])));
                }
                return Partitions.list((String)partitionName, (Literal[][])((Literal[][])lists.build().toArray((Object[])new Literal[0][0])), (Map)properties);
            }
            throw new UnsupportedOperationException(String.format("%s is not a partitioned table", tableName));
        }
        throw new UnsupportedOperationException(String.format("%s is not a partitioned table", tableName));
    }

    private static /* synthetic */ String[][] lambda$extractPartitionInfoFromSql$4(int x$0) {
        return new String[x$0][];
    }
}

