/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.hive.ClientPropertiesMetadata;
import org.apache.gravitino.hive.HiveClientPool;
import org.apache.gravitino.hive.ImmutableConfElement;
import org.apache.gravitino.hive.ImmutableKey;
import org.apache.gravitino.hive.client.HiveClient;
import org.apache.gravitino.utils.ClientPool;
import org.apache.gravitino.utils.PrincipalUtils;
import org.immutables.value.Value;

public class CachedClientPool
implements ClientPool<HiveClient, GravitinoRuntimeException> {
    private static final ClientPropertiesMetadata PROPERTIES_METADATA = new ClientPropertiesMetadata();
    private final Cache<Key, HiveClientPool> clientPoolCache;
    private final Properties conf;
    private final int clientPoolSize;
    private final ScheduledThreadPoolExecutor scheduler;
    private final String name;

    public CachedClientPool(String name, Properties hiveConf, Map<String, String> properties) {
        int clientPoolSize = (Integer)PROPERTIES_METADATA.getOrDefault(properties, "client.pool-size");
        long evictionInterval = (Long)PROPERTIES_METADATA.getOrDefault(properties, "client.pool-cache.eviction-interval-ms");
        this.name = name;
        this.conf = hiveConf;
        this.clientPoolSize = clientPoolSize;
        this.scheduler = new ScheduledThreadPoolExecutor(1, CachedClientPool.newDaemonThreadFactory());
        this.clientPoolCache = Caffeine.newBuilder().expireAfterAccess(evictionInterval, TimeUnit.MILLISECONDS).removalListener((ignored, value, cause) -> ((HiveClientPool)((Object)((Object)value))).close()).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)this.scheduler)).build();
    }

    @VisibleForTesting
    public HiveClientPool clientPool() {
        Key key = CachedClientPool.extractKey();
        return (HiveClientPool)((Object)this.clientPoolCache.get((Object)key, k -> new HiveClientPool(this.name, this.clientPoolSize, this.conf)));
    }

    @VisibleForTesting
    public Cache<Key, HiveClientPool> clientPoolCache() {
        return this.clientPoolCache;
    }

    public <R> R run(ClientPool.Action<R, HiveClient, GravitinoRuntimeException> action) throws GravitinoRuntimeException, InterruptedException {
        return (R)this.clientPool().run(action);
    }

    public <R> R run(ClientPool.Action<R, HiveClient, GravitinoRuntimeException> action, boolean retry) throws GravitinoRuntimeException, InterruptedException {
        return (R)this.clientPool().run(action, retry);
    }

    @VisibleForTesting
    public static Key extractKey() {
        ArrayList elements = Lists.newArrayList();
        elements.add(PrincipalUtils.getCurrentUserName());
        return Key.of(elements);
    }

    private static ThreadFactory newDaemonThreadFactory() {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hive-metastore-cleaner-%d").build();
    }

    public void close() {
        this.clientPoolCache.asMap().forEach((key, value) -> value.close());
        this.clientPoolCache.invalidateAll();
        this.scheduler.shutdownNow();
    }

    @Value.Immutable
    public static abstract class Key {
        abstract List<Object> elements();

        private static Key of(Iterable<?> elements) {
            return ImmutableKey.builder().elements(elements).build();
        }
    }

    @Value.Immutable
    static abstract class ConfElement {
        ConfElement() {
        }

        abstract String key();

        @Nullable
        abstract String value();

        static ConfElement of(String key, String value) {
            return ImmutableConfElement.builder().key(key).value(value).build();
        }
    }
}

