/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.client;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.gravitino.hive.HivePartition;
import org.apache.gravitino.hive.HiveSchema;
import org.apache.gravitino.hive.HiveTable;
import org.apache.gravitino.hive.client.HiveClientClassLoader;
import org.apache.gravitino.hive.client.HiveExceptionConverter;
import org.apache.gravitino.hive.client.HiveShimV2;
import org.apache.gravitino.hive.client.Util;
import org.apache.gravitino.hive.converter.HiveDatabaseConverter;
import org.apache.gravitino.hive.converter.HiveTableConverter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

class HiveShimV3
extends HiveShimV2 {
    private final Method createDatabaseMethod;
    private final Method getDatabaseMethod;
    private final Method getAllDatabasesMethod;
    private final Method alterDatabaseMethod;
    private final Method dropDatabaseMethod;
    private final Method getTableMethod;
    private final Method createTableMethod;
    private final Method alterTableMethod;
    private final Method dropTableMethod;
    private final Method getAllTablesMethod;
    private final Method listTableNamesByFilterMethod;
    private final Method listPartitionNamesMethod;
    private final Method listPartitionsMethod;
    private final Method listPartitionsWithFilterMethod;
    private final Method getPartitionMethod;
    private final Method addPartitionMethod;
    private final Method dropPartitionMethod;
    private final Method getTableObjectsByNameMethod;
    private final Method databaseSetCatalogNameMethod;
    private final Method getCatalogsMethod;
    private final Method tableSetCatalogNameMethod;
    private final Method partitionSetCatalogNameMethod;

    HiveShimV3(Properties properties) {
        super(HiveClientClassLoader.HiveVersion.HIVE3, properties);
        try {
            this.createDatabaseMethod = IMetaStoreClient.class.getMethod("createDatabase", Database.class);
            this.getDatabaseMethod = IMetaStoreClient.class.getMethod("getDatabase", String.class, String.class);
            this.getAllDatabasesMethod = IMetaStoreClient.class.getMethod("getAllDatabases", String.class);
            this.alterDatabaseMethod = IMetaStoreClient.class.getMethod("alterDatabase", String.class, String.class, Database.class);
            this.dropDatabaseMethod = IMetaStoreClient.class.getMethod("dropDatabase", String.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            this.getTableMethod = IMetaStoreClient.class.getMethod("getTable", String.class, String.class, String.class);
            this.createTableMethod = IMetaStoreClient.class.getMethod("createTable", Table.class);
            this.alterTableMethod = IMetaStoreClient.class.getMethod("alter_table", String.class, String.class, String.class, Table.class);
            this.dropTableMethod = IMetaStoreClient.class.getMethod("dropTable", String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE);
            this.getAllTablesMethod = IMetaStoreClient.class.getMethod("getAllTables", String.class, String.class);
            this.listTableNamesByFilterMethod = IMetaStoreClient.class.getMethod("listTableNamesByFilter", String.class, String.class, String.class, Integer.TYPE);
            this.listPartitionNamesMethod = IMetaStoreClient.class.getMethod("listPartitionNames", String.class, String.class, String.class, Integer.TYPE);
            this.listPartitionsMethod = IMetaStoreClient.class.getMethod("listPartitions", String.class, String.class, String.class, Integer.TYPE);
            this.listPartitionsWithFilterMethod = IMetaStoreClient.class.getMethod("listPartitions", String.class, String.class, String.class, List.class, Integer.TYPE);
            this.getPartitionMethod = IMetaStoreClient.class.getMethod("getPartition", String.class, String.class, String.class, List.class);
            this.addPartitionMethod = IMetaStoreClient.class.getMethod("add_partition", Partition.class);
            this.dropPartitionMethod = IMetaStoreClient.class.getMethod("dropPartition", String.class, String.class, String.class, List.class, Boolean.TYPE);
            this.getTableObjectsByNameMethod = IMetaStoreClient.class.getMethod("getTableObjectsByName", String.class, String.class, List.class);
            this.getCatalogsMethod = IMetaStoreClient.class.getMethod("getCatalogs", new Class[0]);
            this.databaseSetCatalogNameMethod = MethodUtils.getAccessibleMethod(Database.class, (String)"setCatalogName", (Class[])new Class[]{String.class});
            this.tableSetCatalogNameMethod = MethodUtils.getAccessibleMethod(Table.class, (String)"setCatName", (Class[])new Class[]{String.class});
            this.partitionSetCatalogNameMethod = MethodUtils.getAccessibleMethod(Partition.class, (String)"setCatName", (Class[])new Class[]{String.class});
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.other("HiveShimV3"));
        }
    }

    @Override
    public IMetaStoreClient createMetaStoreClient(Properties properties) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clientClass = classLoader.loadClass("org.apache.hadoop.hive.metastore.RetryingMetaStoreClient");
            Class<?> confClass = classLoader.loadClass("org.apache.hadoop.conf.Configuration");
            Object conf = confClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Util.updateConfigurationFromProperties(properties, (Configuration)conf);
            Method getProxyMethod = clientClass.getMethod("getProxy", confClass, Boolean.TYPE);
            return (IMetaStoreClient)getProxyMethod.invoke(null, conf, false);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.other("MetaStoreClient"));
        }
    }

    @Override
    public void createDatabase(HiveSchema database) {
        Database db = HiveDatabaseConverter.toHiveDb(database);
        String catalogName = database.catalogName();
        this.invoke(HiveExceptionConverter.ExceptionTarget.other(""), db, this.databaseSetCatalogNameMethod, catalogName);
        this.invoke(HiveExceptionConverter.ExceptionTarget.schema(database.name()), this.client, this.createDatabaseMethod, db);
    }

    @Override
    public List<String> getAllDatabases(String catalogName) {
        return (List)this.invoke(HiveExceptionConverter.ExceptionTarget.catalog(catalogName), this.client, this.getAllDatabasesMethod, catalogName);
    }

    @Override
    public HiveSchema getDatabase(String catalogName, String databaseName) {
        Database db = (Database)this.invoke(HiveExceptionConverter.ExceptionTarget.schema(databaseName), this.client, this.getDatabaseMethod, catalogName, databaseName);
        return HiveDatabaseConverter.fromHiveDB(db);
    }

    @Override
    public void alterDatabase(String catalogName, String databaseName, HiveSchema database) {
        Database db = HiveDatabaseConverter.toHiveDb(database);
        this.invoke(HiveExceptionConverter.ExceptionTarget.other(""), db, this.databaseSetCatalogNameMethod, catalogName);
        this.invoke(HiveExceptionConverter.ExceptionTarget.schema(databaseName), this.client, this.alterDatabaseMethod, catalogName, databaseName, db);
    }

    @Override
    public void dropDatabase(String catalogName, String databaseName, boolean cascade) {
        this.invoke(HiveExceptionConverter.ExceptionTarget.schema(databaseName), this.client, this.dropDatabaseMethod, catalogName, databaseName, true, false, cascade);
    }

    @Override
    public List<String> getAllTables(String catalogName, String databaseName) {
        return (List)this.invoke(HiveExceptionConverter.ExceptionTarget.schema(databaseName), this.client, this.getAllTablesMethod, catalogName, databaseName);
    }

    @Override
    public List<String> listTableNamesByFilter(String catalogName, String databaseName, String filter, short pageSize) {
        Object pageSizeArg = this.convertPageSize(this.listTableNamesByFilterMethod, 3, pageSize);
        return (List)this.invoke(HiveExceptionConverter.ExceptionTarget.schema(databaseName), this.client, this.listTableNamesByFilterMethod, catalogName, databaseName, filter, pageSizeArg);
    }

    @Override
    public HiveTable getTable(String catalogName, String databaseName, String tableName) {
        Table tb = (Table)this.invoke(HiveExceptionConverter.ExceptionTarget.table(tableName), this.client, this.getTableMethod, catalogName, databaseName, tableName);
        return HiveTableConverter.fromHiveTable(tb);
    }

    @Override
    public void alterTable(String catalogName, String databaseName, String tableName, HiveTable alteredHiveTable) {
        Table tb = HiveTableConverter.toHiveTable(alteredHiveTable);
        this.invoke(HiveExceptionConverter.ExceptionTarget.other(""), tb, this.tableSetCatalogNameMethod, catalogName);
        this.invoke(HiveExceptionConverter.ExceptionTarget.table(tableName), this.client, this.alterTableMethod, catalogName, databaseName, tableName, tb);
    }

    @Override
    public void dropTable(String catalogName, String databaseName, String tableName, boolean deleteData, boolean ifPurge) {
        this.invoke(HiveExceptionConverter.ExceptionTarget.table(tableName), this.client, this.dropTableMethod, catalogName, databaseName, tableName, deleteData, ifPurge);
    }

    @Override
    public void createTable(HiveTable hiveTable) {
        String catalogName = hiveTable.catalogName();
        Table tb = HiveTableConverter.toHiveTable(hiveTable);
        this.invoke(HiveExceptionConverter.ExceptionTarget.other(""), tb, this.tableSetCatalogNameMethod, catalogName);
        this.invoke(HiveExceptionConverter.ExceptionTarget.schema(hiveTable.name()), this.client, this.createTableMethod, tb);
    }

    @Override
    public List<String> listPartitionNames(HiveTable table, short pageSize) {
        String catalogName = table.catalogName();
        String databaseName = table.databaseName();
        Object pageSizeArg = this.convertPageSize(this.listPartitionNamesMethod, 3, pageSize);
        return (List)this.invoke(HiveExceptionConverter.ExceptionTarget.table(table.name()), this.client, this.listPartitionNamesMethod, catalogName, databaseName, table.name(), pageSizeArg);
    }

    @Override
    public List<HivePartition> listPartitions(HiveTable table, short pageSize) {
        String catalogName = table.catalogName();
        String databaseName = table.databaseName();
        Object pageSizeArg = this.convertPageSize(this.listPartitionsMethod, 3, pageSize);
        List partitions = (List)this.invoke(HiveExceptionConverter.ExceptionTarget.table(table.name()), this.client, this.listPartitionsMethod, catalogName, databaseName, table.name(), pageSizeArg);
        return partitions.stream().map(p -> HiveTableConverter.fromHivePartition(table, p)).toList();
    }

    @Override
    public List<HivePartition> listPartitions(HiveTable table, List<String> filterPartitionValueList, short pageSize) {
        String catalogName = table.catalogName();
        String databaseName = table.databaseName();
        Object pageSizeArg = this.convertPageSize(this.listPartitionsWithFilterMethod, 4, pageSize);
        List partitions = (List)this.invoke(HiveExceptionConverter.ExceptionTarget.table(table.name()), this.client, this.listPartitionsWithFilterMethod, catalogName, databaseName, table.name(), filterPartitionValueList, pageSizeArg);
        return partitions.stream().map(p -> HiveTableConverter.fromHivePartition(table, p)).toList();
    }

    @Override
    public HivePartition getPartition(HiveTable table, String partitionName) {
        String catalogName = table.catalogName();
        String databaseName = table.databaseName();
        List<String> partitionValues = HivePartition.extractPartitionValues(partitionName);
        Partition partition = (Partition)this.invoke(HiveExceptionConverter.ExceptionTarget.partition(partitionName), this.client, this.getPartitionMethod, catalogName, databaseName, table.name(), partitionValues);
        return HiveTableConverter.fromHivePartition(table, partition);
    }

    @Override
    public HivePartition addPartition(HiveTable table, HivePartition partition) {
        String catalogName = table.catalogName();
        String databaseName = table.databaseName();
        Partition hivePartition = HiveTableConverter.toHivePartition(databaseName, table, partition);
        this.invoke(HiveExceptionConverter.ExceptionTarget.other(""), hivePartition, this.partitionSetCatalogNameMethod, catalogName);
        Partition addedPartition = (Partition)this.invoke(HiveExceptionConverter.ExceptionTarget.partition(partition.name()), this.client, this.addPartitionMethod, hivePartition);
        return HiveTableConverter.fromHivePartition(table, addedPartition);
    }

    @Override
    public void dropPartition(String catalogName, String databaseName, String tableName, String partitionName, boolean deleteData) {
        List<String> partitionValues = HivePartition.extractPartitionValues(partitionName);
        this.invoke(HiveExceptionConverter.ExceptionTarget.partition(partitionName), this.client, this.dropPartitionMethod, catalogName, databaseName, tableName, partitionValues, deleteData);
    }

    @Override
    public List<HiveTable> getTableObjectsByName(String catalogName, String databaseName, List<String> allTables) {
        List tables = (List)this.invoke(HiveExceptionConverter.ExceptionTarget.schema(databaseName), this.client, this.getTableObjectsByNameMethod, catalogName, databaseName, allTables);
        return tables.stream().map(HiveTableConverter::fromHiveTable).toList();
    }

    @Override
    public List<String> getCatalogs() {
        return (List)this.invoke(HiveExceptionConverter.ExceptionTarget.other(""), this.client, this.getCatalogsMethod, new Object[0]);
    }

    private Object invoke(HiveExceptionConverter.ExceptionTarget target, Object object, Method method, Object ... args) {
        try {
            return method.invoke(object, args);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, target);
        }
    }

    private Object convertPageSize(Method method, int paramIndex, short pageSize) {
        if (method.getParameterTypes()[paramIndex] == Integer.TYPE) {
            return (int)pageSize;
        }
        return pageSize;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

