/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;

public class QueueACLsManager {
    private ResourceScheduler scheduler;
    private boolean isACLsEnable;

    @VisibleForTesting
    public QueueACLsManager() {
        this(null, new Configuration());
    }

    public QueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        this.scheduler = scheduler;
        this.isACLsEnable = conf.getBoolean("yarn.acl.enable", false);
    }

    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        if (!this.isACLsEnable) {
            return true;
        }
        return this.scheduler.checkAccess(callerUGI, acl, queueName);
    }
}

