/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.paimon.data.columnar.writable.WritableBooleanVector;
import org.apache.paimon.data.columnar.writable.WritableByteVector;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;
import org.apache.paimon.data.columnar.writable.WritableDoubleVector;
import org.apache.paimon.data.columnar.writable.WritableFloatVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.data.columnar.writable.WritableLongVector;
import org.apache.paimon.data.columnar.writable.WritableShortVector;
import org.apache.paimon.format.parquet.reader.VectorizedValuesReader;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.column.values.ValuesReader;
import org.apache.paimon.shade.org.apache.parquet.io.ParquetDecodingException;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;

public class VectorizedPlainValuesReader
extends ValuesReader
implements VectorizedValuesReader {
    private ByteBufferInputStream in = null;
    private int bitOffset;
    private byte currentByte = 0;

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        this.in = in;
    }

    @Override
    public void skip() {
        throw new UnsupportedOperationException("skip");
    }

    private void updateCurrentByte() {
        try {
            this.currentByte = (byte)this.in.read();
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read a byte", e);
        }
    }

    @Override
    public final void readBooleans(int total, WritableBooleanVector c, int rowId) {
        int i = 0;
        if (this.bitOffset > 0) {
            i = Math.min(8 - this.bitOffset, total);
            c.setBooleans(rowId, i, this.currentByte, this.bitOffset);
            this.bitOffset = this.bitOffset + i & 7;
        }
        while (i + 7 < total) {
            this.updateCurrentByte();
            c.setBooleans(rowId + i, this.currentByte);
            i += 8;
        }
        if (i < total) {
            this.updateCurrentByte();
            this.bitOffset = total - i;
            c.setBooleans(rowId + i, this.bitOffset, this.currentByte, 0);
        }
    }

    @Override
    public final void skipBooleans(int total) {
        int i = 0;
        if (this.bitOffset > 0) {
            i = Math.min(8 - this.bitOffset, total);
            this.bitOffset = this.bitOffset + i & 7;
        }
        if (i + 7 < total) {
            int numBytesToSkip = (total - i) / 8;
            try {
                this.in.skipFully(numBytesToSkip);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Failed to skip bytes", e);
            }
            i += numBytesToSkip * 8;
        }
        if (i < total) {
            this.updateCurrentByte();
            this.bitOffset = total - i;
        }
    }

    private ByteBuffer getBuffer(int length) {
        try {
            return this.in.slice(length).order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes", e);
        }
    }

    @Override
    public final void readIntegers(int total, WritableIntVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.setIntsFromBinary(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.setInt(rowId + i, buffer.getInt());
            }
        }
    }

    @Override
    public void skipIntegers(int total) {
        this.in.skip((long)total * 4L);
    }

    @Override
    public final void readLongs(int total, WritableLongVector c, int rowId) {
        int requiredBytes = total * 8;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.setLongsFromBinary(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.setLong(rowId + i, buffer.getLong());
            }
        }
    }

    @Override
    public void skipLongs(int total) {
        this.in.skip((long)total * 8L);
    }

    @Override
    public final void readFloats(int total, WritableFloatVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.setFloatsFromBinary(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.setFloat(rowId + i, buffer.getFloat());
            }
        }
    }

    @Override
    public void skipFloats(int total) {
        this.in.skip((long)total * 4L);
    }

    @Override
    public final void readDoubles(int total, WritableDoubleVector c, int rowId) {
        int requiredBytes = total * 8;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.setDoublesFromBinary(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.setDouble(rowId + i, buffer.getDouble());
            }
        }
    }

    @Override
    public void skipDoubles(int total) {
        this.in.skip((long)total * 8L);
    }

    @Override
    public final void readBytes(int total, WritableByteVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        for (int i = 0; i < total; ++i) {
            c.setByte(rowId + i, buffer.get());
            buffer.position(buffer.position() + 3);
        }
    }

    @Override
    public final void skipBytes(int total) {
        this.in.skip((long)total * 4L);
    }

    @Override
    public final void readShorts(int total, WritableShortVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        for (int i = 0; i < total; ++i) {
            c.setShort(rowId + i, (short)buffer.getInt());
        }
    }

    @Override
    public void skipShorts(int total) {
        this.in.skip((long)total * 4L);
    }

    @Override
    public final boolean readBoolean() {
        if (this.bitOffset == 0) {
            this.updateCurrentByte();
        }
        boolean v = (this.currentByte & 1 << this.bitOffset) != 0;
        ++this.bitOffset;
        if (this.bitOffset == 8) {
            this.bitOffset = 0;
        }
        return v;
    }

    @Override
    public final int readInteger() {
        return this.getBuffer(4).getInt();
    }

    @Override
    public final long readLong() {
        return this.getBuffer(8).getLong();
    }

    @Override
    public final byte readByte() {
        return (byte)this.readInteger();
    }

    @Override
    public short readShort() {
        return (short)this.readInteger();
    }

    @Override
    public final float readFloat() {
        return this.getBuffer(4).getFloat();
    }

    @Override
    public final double readDouble() {
        return this.getBuffer(8).getDouble();
    }

    @Override
    public final void readBinary(int total, WritableBytesVector v, int rowId) {
        for (int i = 0; i < total; ++i) {
            int len = this.readInteger();
            ByteBuffer buffer = this.getBuffer(len);
            if (buffer.hasArray()) {
                v.putByteArray(rowId + i, buffer.array(), buffer.arrayOffset() + buffer.position(), len);
                continue;
            }
            byte[] bytes = new byte[len];
            buffer.get(bytes);
            v.putByteArray(rowId + i, bytes, 0, bytes.length);
        }
    }

    @Override
    public void skipBinary(int total) {
        for (int i = 0; i < total; ++i) {
            int len = this.readInteger();
            this.in.skip(len);
        }
    }

    @Override
    public final Binary readBinary(int len) {
        ByteBuffer buffer = this.getBuffer(len);
        if (buffer.hasArray()) {
            return Binary.fromConstantByteArray(buffer.array(), buffer.arrayOffset() + buffer.position(), len);
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return Binary.fromConstantByteArray(bytes);
    }

    @Override
    public void skipFixedLenByteArray(int total, int len) {
        this.in.skip((long)total * (long)len);
    }
}

