/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.io;

import org.apache.paimon.shade.org.apache.parquet.column.ColumnReader;
import org.apache.paimon.shade.org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.paimon.shade.org.apache.parquet.filter.RecordFilter;
import org.apache.paimon.shade.org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.paimon.shade.org.apache.parquet.io.MessageColumnIO;
import org.apache.paimon.shade.org.apache.parquet.io.RecordReaderImplementation;
import org.apache.paimon.shade.org.apache.parquet.io.api.RecordMaterializer;

class FilteredRecordReader<T>
extends RecordReaderImplementation<T> {
    private final RecordFilter recordFilter;
    private final long recordCount;
    private long recordsRead = 0L;

    public FilteredRecordReader(MessageColumnIO root, RecordMaterializer<T> recordMaterializer, boolean validating, ColumnReadStoreImpl columnStore, UnboundRecordFilter unboundFilter, long recordCount) {
        super(root, recordMaterializer, validating, columnStore);
        this.recordCount = recordCount;
        this.recordFilter = unboundFilter != null ? unboundFilter.bind(this.getColumnReaders()) : null;
    }

    @Override
    public T read() {
        this.skipToMatch();
        if (this.recordsRead == this.recordCount) {
            return null;
        }
        ++this.recordsRead;
        return super.read();
    }

    @Override
    public boolean shouldSkipCurrentRecord() {
        return false;
    }

    private void skipToMatch() {
        while (this.recordsRead < this.recordCount && !this.recordFilter.isMatch()) {
            ColumnReader columnReader;
            int nextR;
            RecordReaderImplementation.State currentState = this.getState(0);
            do {
                if ((columnReader = currentState.column).getCurrentDefinitionLevel() >= currentState.maxDefinitionLevel) {
                    columnReader.skip();
                }
                columnReader.consume();
            } while ((currentState = currentState.getNextState(nextR = currentState.maxRepetitionLevel == 0 ? 0 : columnReader.getCurrentRepetitionLevel())) != null);
            ++this.recordsRead;
        }
    }
}

