/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UserAggregateDefinition;
import org.apache.derby.impl.sql.compile.ValueNode;

public class AggregateNode
extends UnaryOperatorNode {
    private boolean distinct;
    private AggregateDefinition uad;
    private TableName userAggregateName;
    private StringBuffer aggregatorClassName;
    private String aggregateDefinitionClassName;
    private Class aggregateDefinitionClass;
    private ClassInspector classInspector;
    private String aggregateName;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        super.init(object);
        this.aggregateName = (String)object4;
        if (object2 instanceof UserAggregateDefinition) {
            this.setUserDefinedAggregate((UserAggregateDefinition)object2);
            this.distinct = (Boolean)object3;
        } else if (object2 instanceof TableName) {
            this.userAggregateName = (TableName)object2;
            this.distinct = (Boolean)object3;
        } else {
            this.aggregateDefinitionClass = (Class)object2;
            if (!this.aggregateDefinitionClass.equals(MaxMinAggregateDefinition.class)) {
                this.distinct = (Boolean)object3;
            }
            this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
        }
    }

    private void setUserDefinedAggregate(UserAggregateDefinition userAggregateDefinition) {
        this.uad = userAggregateDefinition;
        this.aggregateDefinitionClass = this.uad.getClass();
        this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
    }

    public ValueNode replaceAggregatesWithColumnReferences(ResultColumnList resultColumnList, int n) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext compilerContext = this.getCompilerContext();
            String string = "SQLCol" + compilerContext.getNextColumnNumber();
            this.generatedRC = (ResultColumn)this.getNodeFactory().getNode(80, string, this, this.getContextManager());
            this.generatedRC.markGenerated();
            this.generatedRef = (ColumnReference)this.getNodeFactory().getNode(62, this.generatedRC.getName(), null, this.getContextManager());
            this.generatedRef.setSource(this.generatedRC);
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (n != -1) {
                this.generatedRef.setTableNumber(n);
            }
            resultColumnList.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceAggregate();
        } else {
            resultColumnList.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    AggregateDefinition getAggregateDefinition() {
        return this.uad;
    }

    public ResultColumn getGeneratedRC() {
        return this.generatedRC;
    }

    public ColumnReference getGeneratedRef() {
        return this.generatedRef;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        Object object;
        Object object2;
        DataDictionary dataDictionary = this.getDataDictionary();
        DataTypeDescriptor dataTypeDescriptor = null;
        ClassFactory classFactory = this.getClassFactory();
        this.classInspector = classFactory.getClassInspector();
        if (this.userAggregateName != null) {
            this.userAggregateName.bind(dataDictionary);
            object2 = AggregateNode.resolveAggregate(dataDictionary, this.getSchemaDescriptor(this.userAggregateName.getSchemaName(), true), this.userAggregateName.getTableName());
            if (object2 == null) {
                throw StandardException.newException("42X94", (Object)AliasDescriptor.getAliasType('G'), (Object)this.userAggregateName.getTableName());
            }
            this.setUserDefinedAggregate(new UserAggregateDefinition((AliasDescriptor)object2));
            this.aggregateName = ((AliasDescriptor)object2).getJavaClassName();
        }
        this.instantiateAggDef();
        if (this.isUserDefinedAggregate()) {
            object2 = ((UserAggregateDefinition)this.uad).getAliasDescriptor();
            this.getCompilerContext().createDependency((Provider)object2);
            if (this.isPrivilegeCollectionRequired()) {
                this.getCompilerContext().addRequiredUsagePriv((PrivilegedSQLObject)object2);
            }
        }
        list.add(this);
        object2 = this.getCompilerContext();
        if (this.operand != null) {
            int n = this.orReliability(16384);
            this.bindOperand(fromList, subqueryList, list);
            object2.setReliability(n);
            object = new HasNodeVisitor(this.getClass(), ResultSetNode.class);
            this.operand.accept((Visitor)object);
            if (((HasNodeVisitor)object).hasNode()) {
                throw StandardException.newException("42Y33", this.getSQLName());
            }
            SelectNode.checkNoWindowFunctions(this.operand, this.aggregateName);
            dataTypeDescriptor = this.operand.getTypeServices();
            if (this.uad instanceof CountAggregateDefinition && !dataTypeDescriptor.isNullable()) {
                this.setOperator(this.aggregateName);
                this.setMethodName(this.aggregateName);
            }
            if (this.distinct && !this.operand.getTypeId().orderable(classFactory)) {
                throw StandardException.newException("X0X67.S", dataTypeDescriptor.getTypeId().getSQLTypeName());
            }
            if (this.operand instanceof UntypedNullConstantNode) {
                throw StandardException.newException("42Y83", this.getSQLName());
            }
        }
        this.aggregatorClassName = new StringBuffer();
        DataTypeDescriptor dataTypeDescriptor2 = this.uad.getAggregator(dataTypeDescriptor, this.aggregatorClassName);
        if (dataTypeDescriptor2 == null) {
            throw StandardException.newException("42Y22", (Object)this.getSQLName(), (Object)this.operand.getTypeId().getSQLTypeName());
        }
        if (this.isUserDefinedAggregate() && (object = ((UserAggregateDefinition)this.uad).castInputValue(this.operand, this.getNodeFactory(), this.getContextManager())) != null) {
            this.operand = ((ValueNode)object).bindExpression(fromList, subqueryList, list);
        }
        this.checkAggregatorClassName(this.aggregatorClassName.toString());
        this.setType(dataTypeDescriptor2);
        return this;
    }

    public static AliasDescriptor resolveAggregate(DataDictionary dataDictionary, SchemaDescriptor schemaDescriptor, String string) throws StandardException {
        if (schemaDescriptor.getUUID() == null) {
            return null;
        }
        List list = dataDictionary.getRoutineList(schemaDescriptor.getUUID().toString(), string, 'G');
        if (list.size() > 0) {
            return (AliasDescriptor)list.get(0);
        }
        return null;
    }

    private void checkAggregatorClassName(String string) throws StandardException {
        this.verifyClassExist(string);
        if (!this.classInspector.assignableTo(string, "org.apache.derby.iapi.sql.execute.ExecAggregator")) {
            throw StandardException.newException("42Y32", (Object)string, (Object)this.getSQLName(), (Object)this.operand.getTypeId().getSQLTypeName());
        }
    }

    private void instantiateAggDef() throws StandardException {
        if (this.uad == null) {
            AggregateDefinition aggregateDefinition;
            String string;
            Class clazz = this.aggregateDefinitionClass;
            if (clazz == null) {
                string = this.aggregateDefinitionClassName;
                this.verifyClassExist(string);
                try {
                    clazz = this.classInspector.getClass(string);
                }
                catch (Throwable throwable) {
                    throw StandardException.unexpectedUserException(throwable);
                }
            }
            string = null;
            try {
                string = clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
            if (!(string instanceof AggregateDefinition)) {
                throw StandardException.newException("42Y00", this.aggregateDefinitionClassName);
            }
            if (string instanceof MaxMinAggregateDefinition) {
                aggregateDefinition = (MaxMinAggregateDefinition)((Object)string);
                if (this.aggregateName.equals("MAX")) {
                    ((MaxMinAggregateDefinition)aggregateDefinition).setMaxOrMin(true);
                } else {
                    ((MaxMinAggregateDefinition)aggregateDefinition).setMaxOrMin(false);
                }
            }
            if (string instanceof SumAvgAggregateDefinition) {
                aggregateDefinition = (SumAvgAggregateDefinition)((Object)string);
                if (this.aggregateName.equals("SUM")) {
                    ((SumAvgAggregateDefinition)aggregateDefinition).setSumOrAvg(true);
                } else {
                    ((SumAvgAggregateDefinition)aggregateDefinition).setSumOrAvg(false);
                }
            }
            this.uad = (AggregateDefinition)((Object)string);
        }
        this.setOperator(this.aggregateName);
        this.setMethodName(this.aggregateDefinitionClassName);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getAggregatorClassName() {
        return this.aggregatorClassName.toString();
    }

    public String getAggregateName() {
        return this.aggregateName;
    }

    public ResultColumn getNewAggregatorResultColumn(DataDictionary dataDictionary) throws StandardException {
        String string = this.aggregatorClassName.toString();
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(string);
        ConstantNode constantNode = this.getNullNode(dataTypeDescriptor);
        constantNode.bindExpression(null, null, null);
        return (ResultColumn)this.getNodeFactory().getNode(80, this.aggregateName, constantNode, this.getContextManager());
    }

    public ResultColumn getNewExpressionResultColumn(DataDictionary dataDictionary) throws StandardException {
        ValueNode valueNode = this.operand == null ? this.getNewNullResultExpression() : this.operand;
        return (ResultColumn)this.getNodeFactory().getNode(80, "##aggregate expression", valueNode, this.getContextManager());
    }

    public ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeServices());
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    public String toString() {
        return "";
    }

    public boolean isConstant() {
        return false;
    }

    public boolean constantExpression(PredicateList predicateList) {
        return false;
    }

    public String getSQLName() {
        if (this.isUserDefinedAggregate()) {
            return ((UserAggregateDefinition)this.uad).getAliasDescriptor().getQualifiedName();
        }
        return this.aggregateName;
    }

    private boolean isUserDefinedAggregate() {
        return this.uad instanceof UserAggregateDefinition;
    }
}

