/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.audit;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Map;
import org.apache.gravitino.audit.AuditLog;
import org.apache.gravitino.audit.AuditLogWriter;
import org.apache.gravitino.audit.Formatter;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAuditWriter
implements AuditLogWriter {
    private static final Logger Log = LoggerFactory.getLogger(FileAuditWriter.class);
    private static final String AUDIT_LOG_FILE_NAME = "fileName";
    private static final String APPEND = "append";
    private static final String FLUSH_INTERVAL_SECS = "flushIntervalSecs";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    @VisibleForTesting
    Writer outWriter;
    @VisibleForTesting
    String fileName;
    private Formatter formatter;
    private boolean append;
    private int flushIntervalSecs;
    private Instant nextFlushTime = Instant.now();

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void init(Formatter formatter, Map<String, String> properties) {
        this.formatter = formatter;
        this.fileName = System.getProperty("gravitino.log.path") + "/" + properties.getOrDefault(AUDIT_LOG_FILE_NAME, "gravitino_audit.log");
        this.append = Boolean.parseBoolean(properties.getOrDefault(APPEND, "true"));
        this.flushIntervalSecs = Integer.parseInt(properties.getOrDefault(FLUSH_INTERVAL_SECS, "10"));
        try {
            FileOutputStream outputStream = new FileOutputStream(this.fileName, this.append);
            this.outWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new GravitinoRuntimeException((Throwable)e, "Init audit log writer fail, filename is %s", new Object[]{this.fileName});
        }
    }

    @Override
    public void doWrite(AuditLog auditLog) {
        String log = auditLog.toString();
        try {
            this.outWriter.write(log + LINE_SEPARATOR);
            this.tryFlush();
        }
        catch (Exception e) {
            Log.warn("Failed to write audit log: {}", (Object)log, (Object)e);
        }
    }

    @Override
    public void close() {
        if (this.outWriter != null) {
            try {
                this.outWriter.close();
            }
            catch (Exception e) {
                Log.warn("Failed to close writer", (Throwable)e);
            }
        }
    }

    @Override
    public String name() {
        return "file";
    }

    private void tryFlush() {
        Instant now = Instant.now();
        if (now.isAfter(this.nextFlushTime)) {
            this.nextFlushTime = now.plusSeconds(this.flushIntervalSecs);
            this.doFlush();
        }
    }

    private void doFlush() {
        if (this.outWriter != null) {
            try {
                this.outWriter.flush();
            }
            catch (Exception e) {
                Log.warn("Flush audit log failed,", (Throwable)e);
            }
        }
    }
}

