/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteArrayDecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteBufferDecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.util.PerformanceAdvisory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class AbstractNativeRawDecoder
extends RawErasureDecoder {
    public static Logger LOG = LoggerFactory.getLogger(AbstractNativeRawDecoder.class);
    private long nativeCoder;

    public AbstractNativeRawDecoder(ErasureCoderOptions coderOptions) {
        super(coderOptions);
    }

    @Override
    protected synchronized void doDecode(ByteBufferDecodingState decodingState) throws IOException {
        ByteBuffer buffer;
        int i;
        if (this.nativeCoder == 0L) {
            throw new IOException(String.format("%s closed", this.getClass().getSimpleName()));
        }
        int[] inputOffsets = new int[decodingState.inputs.length];
        int[] outputOffsets = new int[decodingState.outputs.length];
        for (i = 0; i < decodingState.inputs.length; ++i) {
            buffer = decodingState.inputs[i];
            if (buffer == null) continue;
            inputOffsets[i] = buffer.position();
        }
        for (i = 0; i < decodingState.outputs.length; ++i) {
            buffer = decodingState.outputs[i];
            outputOffsets[i] = buffer.position();
        }
        this.performDecodeImpl(decodingState.inputs, inputOffsets, decodingState.decodeLength, decodingState.erasedIndexes, decodingState.outputs, outputOffsets);
    }

    protected abstract void performDecodeImpl(ByteBuffer[] var1, int[] var2, int var3, int[] var4, ByteBuffer[] var5, int[] var6) throws IOException;

    @Override
    protected void doDecode(ByteArrayDecodingState decodingState) throws IOException {
        PerformanceAdvisory.LOG.debug("convertToByteBufferState is invoked, not efficiently. Please use direct ByteBuffer inputs/outputs");
        ByteBufferDecodingState bbdState = decodingState.convertToByteBufferState();
        this.doDecode(bbdState);
        for (int i = 0; i < decodingState.outputs.length; ++i) {
            bbdState.outputs[i].get(decodingState.outputs[i], decodingState.outputOffsets[i], decodingState.decodeLength);
        }
    }

    @Override
    public boolean preferDirectBuffer() {
        return true;
    }
}

