/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.ops;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.IcebergDataTypeConverter;
import org.apache.gravitino.iceberg.common.ops.IcebergCatalogWrapper;
import org.apache.gravitino.rel.TableChange;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class IcebergCatalogWrapperHelper {
    @VisibleForTesting
    public static final Joiner DOT = Joiner.on((String)".");
    private static final Set<String> IcebergReservedProperties = ImmutableSet.of((Object)"location", (Object)"comment", (Object)"current-snapshot-id", (Object)"cherry-pick-snapshot-id", (Object)"sort-order", (Object)"identifier-fields", (Object[])new String[0]);
    private Catalog icebergCatalog;

    public IcebergCatalogWrapperHelper(Catalog icebergCatalog) {
        this.icebergCatalog = icebergCatalog;
    }

    private void doDeleteColumn(UpdateSchema icebergUpdateSchema, TableChange.DeleteColumn deleteColumn, Schema icebergTableSchema) {
        Types.NestedField deleteField = icebergTableSchema.findField(DOT.join((Object[])deleteColumn.fieldName()));
        if (deleteField == null) {
            if (deleteColumn.getIfExists().booleanValue()) {
                return;
            }
            throw new IllegalArgumentException("delete column not exists: " + DOT.join((Object[])deleteColumn.fieldName()));
        }
        icebergUpdateSchema.deleteColumn(DOT.join((Object[])deleteColumn.fieldName()));
    }

    private void doUpdateColumnComment(UpdateSchema icebergUpdateSchema, TableChange.UpdateColumnComment updateColumnComment) {
        icebergUpdateSchema.updateColumnDoc(DOT.join((Object[])updateColumnComment.fieldName()), updateColumnComment.getNewComment());
    }

    private void doUpdateColumnNullability(UpdateSchema icebergUpdateSchema, TableChange.UpdateColumnNullability updateColumnNullability) {
        if (updateColumnNullability.nullable()) {
            icebergUpdateSchema.makeColumnOptional(DOT.join((Object[])updateColumnNullability.fieldName()));
        } else {
            icebergUpdateSchema.requireColumn(DOT.join((Object[])updateColumnNullability.fieldName()));
        }
    }

    private void doSetProperty(UpdateProperties icebergUpdateProperties, TableChange.SetProperty setProperty) {
        icebergUpdateProperties.set(setProperty.getProperty(), setProperty.getValue());
    }

    private void doRemoveProperty(UpdateProperties icebergUpdateProperties, TableChange.RemoveProperty removeProperty) {
        icebergUpdateProperties.remove(removeProperty.getProperty());
    }

    private void doRenameColumn(UpdateSchema icebergUpdateSchema, TableChange.RenameColumn renameColumn) {
        icebergUpdateSchema.renameColumn(DOT.join((Object[])renameColumn.fieldName()), renameColumn.getNewName());
    }

    private void doMoveColumn(UpdateSchema icebergUpdateSchema, String[] fieldName, TableChange.ColumnPosition columnPosition) {
        if (columnPosition instanceof TableChange.After) {
            TableChange.After after = (TableChange.After)columnPosition;
            String peerName = IcebergCatalogWrapperHelper.getSiblingName(fieldName, after.getColumn());
            icebergUpdateSchema.moveAfter(DOT.join((Object[])fieldName), peerName);
        } else if (columnPosition instanceof TableChange.First) {
            icebergUpdateSchema.moveFirst(DOT.join((Object[])fieldName));
        } else {
            throw new UnsupportedOperationException("Iceberg doesn't support column position: " + columnPosition.getClass().getSimpleName());
        }
    }

    private void doUpdateColumnPosition(UpdateSchema icebergUpdateSchema, TableChange.UpdateColumnPosition updateColumnPosition) {
        this.doMoveColumn(icebergUpdateSchema, updateColumnPosition.fieldName(), updateColumnPosition.getPosition());
    }

    private void doUpdateColumnType(UpdateSchema icebergUpdateSchema, TableChange.UpdateColumnType updateColumnType, Schema icebergTableSchema) {
        String fieldName = DOT.join((Object[])updateColumnType.fieldName());
        Preconditions.checkArgument((icebergTableSchema.findField(fieldName) != null ? 1 : 0) != 0, (String)"Cannot update missing field: %s", (Object)fieldName);
        icebergTableSchema.findField(fieldName).isOptional();
        Type type = IcebergDataTypeConverter.CONVERTER.fromGravitino(updateColumnType.getNewDataType());
        Preconditions.checkArgument((boolean)type.isPrimitiveType(), (String)"Cannot update %s, not a primitive type: %s", (Object)fieldName, (Object)type);
        icebergUpdateSchema.updateColumn(fieldName, (Type.PrimitiveType)type);
    }

    private void doAddColumn(UpdateSchema icebergUpdateSchema, TableChange.AddColumn addColumn) {
        if (addColumn.isAutoIncrement()) {
            throw new IllegalArgumentException("Iceberg doesn't support auto increment column");
        }
        if (addColumn.isNullable()) {
            icebergUpdateSchema.addColumn(IcebergCatalogWrapperHelper.getParentName(addColumn.fieldName()), IcebergCatalogWrapperHelper.getLeafName(addColumn.fieldName()), IcebergDataTypeConverter.CONVERTER.fromGravitino(addColumn.getDataType()), addColumn.getComment());
        } else {
            icebergUpdateSchema.addRequiredColumn(IcebergCatalogWrapperHelper.getParentName(addColumn.fieldName()), IcebergCatalogWrapperHelper.getLeafName(addColumn.fieldName()), IcebergDataTypeConverter.CONVERTER.fromGravitino(addColumn.getDataType()), addColumn.getComment());
        }
        if (!TableChange.ColumnPosition.defaultPos().equals(addColumn.getPosition())) {
            this.doMoveColumn(icebergUpdateSchema, addColumn.fieldName(), addColumn.getPosition());
        }
    }

    private void alterTableProperty(UpdateProperties icebergUpdateProperties, List<TableChange> propertyChanges) {
        for (TableChange change : propertyChanges) {
            if (change instanceof TableChange.RemoveProperty) {
                this.doRemoveProperty(icebergUpdateProperties, (TableChange.RemoveProperty)change);
                continue;
            }
            if (change instanceof TableChange.SetProperty) {
                this.doSetProperty(icebergUpdateProperties, (TableChange.SetProperty)change);
                continue;
            }
            throw new UnsupportedOperationException("Iceberg doesn't support table change: " + change.getClass().getSimpleName() + " for now");
        }
        icebergUpdateProperties.commit();
    }

    private void alterTableColumn(UpdateSchema icebergUpdateSchema, List<TableChange.ColumnChange> columnChanges, Schema icebergTableSchema) {
        for (TableChange.ColumnChange change : columnChanges) {
            if (change instanceof TableChange.AddColumn) {
                this.doAddColumn(icebergUpdateSchema, (TableChange.AddColumn)change);
                continue;
            }
            if (change instanceof TableChange.DeleteColumn) {
                this.doDeleteColumn(icebergUpdateSchema, (TableChange.DeleteColumn)change, icebergTableSchema);
                continue;
            }
            if (change instanceof TableChange.UpdateColumnPosition) {
                this.doUpdateColumnPosition(icebergUpdateSchema, (TableChange.UpdateColumnPosition)change);
                continue;
            }
            if (change instanceof TableChange.RenameColumn) {
                this.doRenameColumn(icebergUpdateSchema, (TableChange.RenameColumn)change);
                continue;
            }
            if (change instanceof TableChange.UpdateColumnType) {
                this.doUpdateColumnType(icebergUpdateSchema, (TableChange.UpdateColumnType)change, icebergTableSchema);
                continue;
            }
            if (change instanceof TableChange.UpdateColumnComment) {
                this.doUpdateColumnComment(icebergUpdateSchema, (TableChange.UpdateColumnComment)change);
                continue;
            }
            if (change instanceof TableChange.UpdateColumnNullability) {
                this.doUpdateColumnNullability(icebergUpdateSchema, (TableChange.UpdateColumnNullability)change);
                continue;
            }
            if (change instanceof TableChange.UpdateColumnAutoIncrement) {
                throw new IllegalArgumentException("Iceberg doesn't support auto increment column");
            }
            throw new UnsupportedOperationException("Iceberg doesn't support " + change.getClass().getSimpleName() + " for now");
        }
        icebergUpdateSchema.commit();
    }

    public IcebergCatalogWrapper.IcebergTableChange buildIcebergTableChanges(NameIdentifier gravitinoNameIdentifier, TableChange ... tableChanges) {
        TableIdentifier icebergTableIdentifier = TableIdentifier.of((org.apache.iceberg.catalog.Namespace)org.apache.iceberg.catalog.Namespace.of((String[])gravitinoNameIdentifier.namespace().levels()), (String)gravitinoNameIdentifier.name());
        ArrayList gravitinoColumnChanges = Lists.newArrayList();
        ArrayList gravitinoPropertyChanges = Lists.newArrayList();
        for (TableChange change : tableChanges) {
            if (change instanceof TableChange.ColumnChange) {
                gravitinoColumnChanges.add((TableChange.ColumnChange)change);
                continue;
            }
            if (change instanceof TableChange.UpdateComment) {
                TableChange.UpdateComment updateComment = (TableChange.UpdateComment)change;
                gravitinoPropertyChanges.add(new TableChange.SetProperty("comment", updateComment.getNewComment()));
                continue;
            }
            if (change instanceof TableChange.RemoveProperty) {
                TableChange.RemoveProperty removeProperty = (TableChange.RemoveProperty)change;
                Preconditions.checkArgument((!IcebergReservedProperties.contains(removeProperty.getProperty()) ? 1 : 0) != 0, (Object)(removeProperty.getProperty() + " is not allowed to remove properties"));
                gravitinoPropertyChanges.add(removeProperty);
                continue;
            }
            if (change instanceof TableChange.SetProperty) {
                TableChange.SetProperty setProperty = (TableChange.SetProperty)change;
                Preconditions.checkArgument((!IcebergReservedProperties.contains(setProperty.getProperty()) ? 1 : 0) != 0, (Object)(setProperty.getProperty() + " is not allowed to Set properties"));
                gravitinoPropertyChanges.add(setProperty);
                continue;
            }
            if (change instanceof TableChange.RenameTable) {
                throw new RuntimeException("RenameTable shouldn't use tableUpdate interface");
            }
            throw new UnsupportedOperationException("Iceberg doesn't support " + String.valueOf(change.getClass()) + "for now");
        }
        Table icebergBaseTable = this.icebergCatalog.loadTable(icebergTableIdentifier);
        Transaction transaction = icebergBaseTable.newTransaction();
        IcebergCatalogWrapper.IcebergTableChange icebergTableChange = new IcebergCatalogWrapper.IcebergTableChange(icebergTableIdentifier, transaction);
        if (!gravitinoColumnChanges.isEmpty()) {
            this.alterTableColumn(transaction.updateSchema(), gravitinoColumnChanges, icebergBaseTable.schema());
        }
        if (!gravitinoPropertyChanges.isEmpty()) {
            this.alterTableProperty(transaction.updateProperties(), gravitinoPropertyChanges);
        }
        return icebergTableChange;
    }

    public static org.apache.iceberg.catalog.Namespace getIcebergNamespace(Namespace namespace) {
        return IcebergCatalogWrapperHelper.getIcebergNamespace(namespace.level(namespace.length() - 1));
    }

    public static org.apache.iceberg.catalog.Namespace getIcebergNamespace(String ... level) {
        return org.apache.iceberg.catalog.Namespace.of((String[])level);
    }

    public static TableIdentifier buildIcebergTableIdentifier(Namespace namespace, String name) {
        String[] levels = namespace.levels();
        return TableIdentifier.of((String[])new String[]{levels[levels.length - 1], name});
    }

    public static TableIdentifier buildIcebergTableIdentifier(NameIdentifier nameIdentifier) {
        String[] levels = nameIdentifier.namespace().levels();
        return TableIdentifier.of((String[])new String[]{levels[levels.length - 1], nameIdentifier.name()});
    }

    @VisibleForTesting
    static String getParentName(String[] fields) {
        if (fields.length > 1) {
            return DOT.join((Object[])Arrays.copyOfRange(fields, 0, fields.length - 1));
        }
        return null;
    }

    @VisibleForTesting
    static String getLeafName(String[] fields) {
        Preconditions.checkArgument((fields.length > 0 ? 1 : 0) != 0, (Object)"Invalid field name: at least one name is required");
        return fields[fields.length - 1];
    }

    @VisibleForTesting
    static String getSiblingName(String[] originalField, String targetField) {
        if (originalField.length > 1) {
            Object[] peerNames = Arrays.copyOf(originalField, originalField.length);
            peerNames[originalField.length - 1] = targetField;
            return DOT.join(peerNames);
        }
        return targetField;
    }

    @VisibleForTesting
    static Set<String> getIcebergReservedProperties() {
        return IcebergReservedProperties;
    }
}

