/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.FileSystemCatalog;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.table.CatalogTableType;

public class FileSystemCatalogFactory
implements CatalogFactory {
    public static final String IDENTIFIER = "filesystem";

    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Catalog create(FileIO fileIO, Path warehouse, CatalogContext context) {
        if (!CatalogTableType.MANAGED.equals(context.options().get(CatalogOptions.TABLE_TYPE))) {
            throw new IllegalArgumentException("Only managed table is supported in File system catalog.");
        }
        return new FileSystemCatalog(fileIO, warehouse, context.options());
    }
}

