/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.paimon.utils.OperatingSystem;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ThrowingConsumer;

public class FileIOUtils {
    private static final Object DELETE_LOCK = new Object();
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int BUFFER_SIZE = 4096;

    public static void writeCompletely(WritableByteChannel channel, ByteBuffer src) throws IOException {
        while (src.hasRemaining()) {
            channel.write(src);
        }
    }

    public static String readFile(File file, String charsetName) throws IOException {
        byte[] bytes = FileIOUtils.readAllBytes(file.toPath());
        return new String(bytes, charsetName);
    }

    public static String readFileUtf8(File file) throws IOException {
        return FileIOUtils.readFile(file, "UTF-8");
    }

    public static void writeFile(File file, String contents, String encoding) throws IOException {
        byte[] bytes = contents.getBytes(encoding);
        Files.write(file.toPath(), bytes, StandardOpenOption.WRITE);
    }

    public static void writeFileUtf8(File file, String contents) throws IOException {
        FileIOUtils.writeFile(file, contents, "UTF-8");
    }

    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        FileIOUtils.writeByteArrayToFile(file, data, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToFile(File file, byte[] data, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileIOUtils.openOutputStream(file, append);
            ((OutputStream)out).write(data);
            ((OutputStream)out).close();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    /*
     * Exception decompiling
     */
    public static byte[] readAllBytes(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] read(InputStream source, int initialSize) throws IOException {
        int capacity = initialSize;
        byte[] buf = new byte[capacity];
        int nread = 0;
        while (true) {
            int n;
            if ((n = source.read(buf, nread, Math.min(capacity - nread, 4096))) > 0) {
                nread += n;
                continue;
            }
            if (n < 0 || (n = source.read()) < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity = Math.max(capacity << 1, 4096);
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n;
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    public static void deleteFileOrDirectory(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (String)"file");
        FileIOUtils.guardIfNotThreadSafe(FileIOUtils::deleteFileOrDirectoryInternal, file);
    }

    public static void deleteDirectory(File directory) throws IOException {
        Preconditions.checkNotNull((Object)directory, (String)"directory");
        FileIOUtils.guardIfNotThreadSafe(FileIOUtils::deleteDirectoryInternal, directory);
    }

    private static void deleteDirectoryInternal(File directory) throws IOException {
        if (directory.isDirectory()) {
            try {
                FileIOUtils.cleanDirectoryInternal(directory);
            }
            catch (FileNotFoundException ignored) {
                return;
            }
            Files.deleteIfExists(directory.toPath());
        } else if (directory.exists()) {
            throw new IOException(directory + " is not a directory");
        }
    }

    private static void cleanDirectoryInternal(File directory) throws IOException {
        if (Files.isSymbolicLink(directory.toPath())) {
            return;
        }
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files == null) {
                if (directory.exists()) {
                    throw new IOException("Failed to list contents of " + directory);
                }
                throw new FileNotFoundException(directory.toString());
            }
            for (File file : files) {
                if (file == null) continue;
                FileIOUtils.deleteFileOrDirectory(file);
            }
        } else {
            if (directory.exists()) {
                throw new IOException(directory + " is not a directory but a regular file");
            }
            throw new FileNotFoundException(directory.toString());
        }
    }

    private static void deleteFileOrDirectoryInternal(File file) throws IOException {
        if (file.isDirectory()) {
            FileIOUtils.deleteDirectoryInternal(file);
        } else {
            Files.deleteIfExists(file.toPath());
        }
    }

    private static void guardIfNotThreadSafe(ThrowingConsumer<File, IOException> toRun, File file) throws IOException {
        if (OperatingSystem.isWindows()) {
            FileIOUtils.guardIfWindows(toRun, file);
            return;
        }
        if (OperatingSystem.isMac()) {
            FileIOUtils.guardIfMac(toRun, file);
            return;
        }
        toRun.accept(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void guardIfWindows(ThrowingConsumer<File, IOException> toRun, File file) throws IOException {
        Object object = DELETE_LOCK;
        synchronized (object) {
            for (int attempt = 1; attempt <= 10; ++attempt) {
                try {
                    toRun.accept(file);
                    break;
                }
                catch (AccessDeniedException accessDeniedException) {
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException("operation interrupted");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void guardIfMac(ThrowingConsumer<File, IOException> toRun, File file) throws IOException {
        Object object = DELETE_LOCK;
        synchronized (object) {
            toRun.accept(file);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("operation interrupted");
            }
        }
    }

    public static void deleteDirectoryQuietly(File directory) {
        if (directory == null) {
            return;
        }
        try {
            FileIOUtils.deleteDirectory(directory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

