/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.OwnerMetaBaseSQLProvider;
import org.apache.ibatis.annotations.Param;

public class OwnerMetaPostgreSQLProvider
extends OwnerMetaBaseSQLProvider {
    @Override
    public String softDeleteOwnerRelByMetadataObjectIdAndType(Long metadataObjectId, String metadataObjectType) {
        return "UPDATE owner_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metadata_object_id = #{metadataObjectId} AND metadata_object_type = #{metadataObjectType} AND deleted_at = 0";
    }

    @Override
    public String softDeleteOwnerRelByOwnerIdAndType(Long ownerId, String ownerType) {
        return "UPDATE owner_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE owner_id = #{ownerId} AND owner_type = #{ownerType} AND deleted_at = 0";
    }

    @Override
    public String softDeleteOwnerRelByMetalakeId(Long metalakeId) {
        return "UPDATE owner_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteOwnerRelByCatalogId(Long catalogId) {
        return "UPDATE owner_meta ot SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE ot.deleted_at = 0 AND EXISTS ( SELECT ct.catalog_id FROM catalog_meta ct WHERE ct.catalog_id = #{catalogId} AND ct.catalog_id = ot.metadata_object_id AND ot.metadata_object_type = 'CATALOG' UNION SELECT st.catalog_id FROM schema_meta st WHERE st.catalog_id = #{catalogId} AND st.schema_id = ot.metadata_object_id AND ot.metadata_object_type = 'SCHEMA' UNION SELECT tt.catalog_id FROM topic_meta tt WHERE tt.catalog_id = #{catalogId} AND tt.topic_id = ot.metadata_object_id AND ot.metadata_object_type = 'TOPIC' UNION SELECT tat.catalog_id FROM table_meta tat WHERE tat.catalog_id = #{catalogId} AND tat.table_id = ot.metadata_object_id AND ot.metadata_object_type = 'TABLE' UNION SELECT ft.catalog_id FROM fileset_meta ft WHERE ft.catalog_id = #{catalogId} AND ft.fileset_id = ot.metadata_object_id AND ot.metadata_object_type = 'FILESET' UNION SELECT mt.catalog_id FROM model_meta mt WHERE mt.catalog_id = #{catalogId} AND mt.model_id = ot.metadata_object_id AND ot.metadata_object_type = 'MODEL')";
    }

    @Override
    public String softDeleteOwnerRelBySchemaId(Long schemaId) {
        return "UPDATE owner_meta ot SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE ot.deleted_at = 0 AND EXISTS ( SELECT st.schema_id FROM schema_meta st WHERE st.schema_id = #{schemaId} AND st.schema_id = ot.metadata_object_id AND ot.metadata_object_type = 'SCHEMA' UNION SELECT tt.schema_id FROM topic_meta tt WHERE tt.schema_id = #{schemaId} AND tt.topic_id = ot.metadata_object_id AND ot.metadata_object_type = 'TOPIC' UNION SELECT tat.schema_id FROM table_meta tat WHERE tat.schema_id = #{schemaId} AND tat.table_id = ot.metadata_object_id AND ot.metadata_object_type = 'TABLE' UNION SELECT ft.schema_id FROM fileset_meta ft WHERE ft.schema_id = #{schemaId} AND ft.fileset_id = ot.metadata_object_id AND ot.metadata_object_type = 'FILESET' UNION SELECT mt.schema_id FROM model_meta mt WHERE mt.schema_id = #{schemaId} AND mt.model_id = ot.metadata_object_id AND ot.metadata_object_type = 'MODEL')";
    }

    @Override
    public String deleteOwnerMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM owner_meta WHERE id IN (SELECT id FROM owner_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

