/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.AllocationTagNamespace;
import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.TargetApplications;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraintTransformations;
import org.apache.hadoop.yarn.exceptions.InvalidAllocationTagException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class PlacementConstraintsUtil {
    private static final Log LOG = LogFactory.getLog(PlacementConstraintsUtil.class);

    private PlacementConstraintsUtil() {
    }

    private static AllocationTagNamespace getAllocationTagNamespace(ApplicationId currentAppId, String targetKey, AllocationTagsManager atm) throws InvalidAllocationTagException {
        AllocationTagNamespace namespace = AllocationTagNamespace.parse((String)targetKey);
        if (!namespace.isIntraApp() && !namespace.isSingleInterApp()) {
            throw new InvalidAllocationTagException("Only support " + AllocationTagNamespaceType.SELF.toString() + " and " + AllocationTagNamespaceType.APP_ID + " now," + namespace.toString() + " is not supported yet!");
        }
        TargetApplications ta = new TargetApplications(currentAppId, atm.getAllApplicationIds());
        namespace.evaluate(ta);
        return namespace;
    }

    private static ApplicationId getNamespaceScope(AllocationTagNamespace namespace) throws InvalidAllocationTagException {
        if (namespace.getNamespaceScope() == null || namespace.getNamespaceScope().size() != 1) {
            throw new InvalidAllocationTagException("Invalid allocation tag namespace " + namespace.toString() + ", expecting it is not null and only 1 application ID in the scope.");
        }
        return (ApplicationId)namespace.getNamespaceScope().iterator().next();
    }

    private static boolean canSatisfySingleConstraintExpression(ApplicationId targetApplicationId, PlacementConstraint.SingleConstraint sc, PlacementConstraint.TargetExpression te, SchedulerNode node, AllocationTagsManager tm) throws InvalidAllocationTagsQueryException {
        boolean checkMaxCardinality;
        ApplicationId effectiveAppID;
        try {
            AllocationTagNamespace namespace = PlacementConstraintsUtil.getAllocationTagNamespace(targetApplicationId, te.getTargetKey(), tm);
            effectiveAppID = PlacementConstraintsUtil.getNamespaceScope(namespace);
        }
        catch (InvalidAllocationTagException e) {
            throw new InvalidAllocationTagsQueryException((YarnException)((Object)e));
        }
        long minScopeCardinality = 0L;
        long maxScopeCardinality = 0L;
        int desiredMinCardinality = sc.getMinCardinality();
        int desiredMaxCardinality = sc.getMaxCardinality();
        boolean checkMinCardinality = desiredMinCardinality > 0;
        boolean bl = checkMaxCardinality = desiredMaxCardinality < Integer.MAX_VALUE;
        if (sc.getScope().equals("node")) {
            if (checkMinCardinality) {
                minScopeCardinality = tm.getNodeCardinalityByOp(node.getNodeID(), effectiveAppID, te.getTargetValues(), Long::max);
            }
            if (checkMaxCardinality) {
                maxScopeCardinality = tm.getNodeCardinalityByOp(node.getNodeID(), effectiveAppID, te.getTargetValues(), Long::min);
            }
        } else if (sc.getScope().equals("rack")) {
            if (checkMinCardinality) {
                minScopeCardinality = tm.getRackCardinalityByOp(node.getRackName(), effectiveAppID, te.getTargetValues(), Long::max);
            }
            if (checkMaxCardinality) {
                maxScopeCardinality = tm.getRackCardinalityByOp(node.getRackName(), effectiveAppID, te.getTargetValues(), Long::min);
            }
        }
        return !(desiredMinCardinality > 0 && minScopeCardinality < (long)desiredMinCardinality || desiredMaxCardinality != Integer.MAX_VALUE && maxScopeCardinality > (long)desiredMaxCardinality);
    }

    private static boolean canSatisfyNodePartitionConstraintExpresssion(PlacementConstraint.TargetExpression targetExpression, SchedulerNode schedulerNode) {
        Set values = targetExpression.getTargetValues();
        if (values == null || values.isEmpty()) {
            return schedulerNode.getPartition().equals("");
        }
        String nodePartition = (String)values.iterator().next();
        return nodePartition.equals(schedulerNode.getPartition());
    }

    private static boolean canSatisfySingleConstraint(ApplicationId applicationId, PlacementConstraint.SingleConstraint singleConstraint, SchedulerNode schedulerNode, AllocationTagsManager tagsManager) throws InvalidAllocationTagsQueryException {
        for (PlacementConstraint.TargetExpression currentExp : singleConstraint.getTargetExpressions()) {
            if (currentExp.getTargetType().equals((Object)PlacementConstraint.TargetExpression.TargetType.ALLOCATION_TAG)) {
                if (PlacementConstraintsUtil.canSatisfySingleConstraintExpression(applicationId, singleConstraint, currentExp, schedulerNode, tagsManager)) continue;
                return false;
            }
            if (!currentExp.getTargetType().equals((Object)PlacementConstraint.TargetExpression.TargetType.NODE_ATTRIBUTE) || !currentExp.getTargetKey().equals("yarn_node_partition/")) continue;
            PlacementConstraintsUtil.canSatisfyNodePartitionConstraintExpresssion(currentExp, schedulerNode);
        }
        return true;
    }

    private static boolean canSatisfyAndConstraint(ApplicationId appId, PlacementConstraint.And constraint, SchedulerNode node, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        for (PlacementConstraint.AbstractConstraint child : constraint.getChildren()) {
            if (PlacementConstraintsUtil.canSatisfyConstraints(appId, child.build(), node, atm)) continue;
            return false;
        }
        return true;
    }

    private static boolean canSatisfyOrConstraint(ApplicationId appId, PlacementConstraint.Or constraint, SchedulerNode node, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        for (PlacementConstraint.AbstractConstraint child : constraint.getChildren()) {
            if (!PlacementConstraintsUtil.canSatisfyConstraints(appId, child.build(), node, atm)) continue;
            return true;
        }
        return false;
    }

    private static boolean canSatisfyConstraints(ApplicationId appId, PlacementConstraint constraint, SchedulerNode node, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        if (constraint == null) {
            return true;
        }
        PlacementConstraintTransformations.SingleConstraintTransformer singleTransformer = new PlacementConstraintTransformations.SingleConstraintTransformer(constraint);
        PlacementConstraint.AbstractConstraint sConstraintExpr = (constraint = singleTransformer.transform()).getConstraintExpr();
        if (sConstraintExpr instanceof PlacementConstraint.SingleConstraint) {
            PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
            return PlacementConstraintsUtil.canSatisfySingleConstraint(appId, single, node, atm);
        }
        if (sConstraintExpr instanceof PlacementConstraint.And) {
            PlacementConstraint.And and = (PlacementConstraint.And)sConstraintExpr;
            return PlacementConstraintsUtil.canSatisfyAndConstraint(appId, and, node, atm);
        }
        if (sConstraintExpr instanceof PlacementConstraint.Or) {
            PlacementConstraint.Or or = (PlacementConstraint.Or)sConstraintExpr;
            return PlacementConstraintsUtil.canSatisfyOrConstraint(appId, or, node, atm);
        }
        throw new InvalidAllocationTagsQueryException("Unsupported type of constraint: " + sConstraintExpr.getClass().getSimpleName());
    }

    public static boolean canSatisfyConstraints(ApplicationId applicationId, SchedulingRequest request, SchedulerNode schedulerNode, PlacementConstraintManager pcm, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        Set sourceTags = null;
        PlacementConstraint pc = null;
        if (request != null) {
            sourceTags = request.getAllocationTags();
            pc = request.getPlacementConstraint();
        }
        return PlacementConstraintsUtil.canSatisfyConstraints(applicationId, pcm.getMultilevelConstraint(applicationId, sourceTags, pc), schedulerNode, atm);
    }
}

