/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkDatabaseCorruptionTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(ZkDatabaseCorruptionTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    private final QuorumBase qb = new QuorumBase();

    @Before
    public void setUp() throws Exception {
        LOG.info("STARTING quorum " + this.getClass().getName());
        this.qb.setUp();
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("STOPPING quorum " + this.getClass().getName());
    }

    private void corruptFile(File f) throws IOException {
        RandomAccessFile outFile = new RandomAccessFile(f, "rw");
        outFile.write("fail servers".getBytes());
        outFile.close();
    }

    private void corruptAllSnapshots(File snapDir) throws IOException {
        File[] listFiles;
        for (File f : listFiles = snapDir.listFiles()) {
            if (!f.getName().startsWith("snapshot")) continue;
            this.corruptFile(f);
        }
    }

    @Test
    public void testCorruption() throws Exception {
        int i;
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ZooKeeper zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            public void process(WatchedEvent event) {
            }
        });
        SyncRequestProcessor.setSnapCount((int)100);
        for (int i2 = 0; i2 < 2000; ++i2) {
            zk.create("/0-" + i2, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)new NoopStringCallback(), null);
        }
        zk.close();
        long leaderSid = 1L;
        QuorumPeer leader = null;
        for (QuorumPeer quorumPeer : Arrays.asList(this.qb.s1, this.qb.s2, this.qb.s3, this.qb.s4, this.qb.s5)) {
            if (quorumPeer.getPeerState() == QuorumPeer.ServerState.LEADING) {
                leader = quorumPeer;
                break;
            }
            ++leaderSid;
        }
        Assert.assertNotNull((String)"Cannot find the leader.", leader);
        leader.shutdown();
        FileTxnSnapLog snapLog = leader.getTxnFactory();
        File snapDir = snapLog.getSnapDir();
        this.corruptAllSnapshots(snapDir);
        this.qb.shutdownServers();
        this.qb.setupServers();
        if (leaderSid != 1L) {
            this.qb.s1.start();
        } else {
            leader = this.qb.s1;
        }
        if (leaderSid != 2L) {
            this.qb.s2.start();
        } else {
            leader = this.qb.s2;
        }
        if (leaderSid != 3L) {
            this.qb.s3.start();
        } else {
            leader = this.qb.s3;
        }
        if (leaderSid != 4L) {
            this.qb.s4.start();
        } else {
            leader = this.qb.s4;
        }
        if (leaderSid != 5L) {
            this.qb.s5.start();
        } else {
            leader = this.qb.s5;
        }
        try {
            leader.start();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException re) {
            LOG.info("Got an error: expected", (Throwable)re);
        }
        String[] list = this.qb.hostPort.split(",");
        for (i = 0; i < 5; ++i) {
            if (leaderSid != (long)(i + 1)) {
                String hp = list[i];
                Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(hp, CONNECTION_TIMEOUT));
                LOG.info("{} is accepting client connections", (Object)hp);
                continue;
            }
            LOG.info("Skipping the leader");
        }
        zk = this.qb.createClient();
        SyncRequestProcessor.setSnapCount((int)100);
        for (i = 2000; i < 4000; ++i) {
            zk.create("/0-" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)new NoopStringCallback(), null);
        }
        zk.close();
        if (leaderSid != 1L) {
            QuorumBase.shutdown(this.qb.s1);
        }
        if (leaderSid != 2L) {
            QuorumBase.shutdown(this.qb.s2);
        }
        if (leaderSid != 3L) {
            QuorumBase.shutdown(this.qb.s3);
        }
        if (leaderSid != 4L) {
            QuorumBase.shutdown(this.qb.s4);
        }
        if (leaderSid != 5L) {
            QuorumBase.shutdown(this.qb.s5);
        }
    }

    private class NoopStringCallback
    implements AsyncCallback.StringCallback {
        private NoopStringCallback() {
        }

        public void processResult(int rc, String path, Object ctx, String name) {
        }
    }
}

