/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.csn;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.csn.InvalidCSNException;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Csn
implements Comparable<Csn> {
    private static final Logger LOG = LoggerFactory.getLogger(Csn.class);
    private final long timestamp;
    private final int replicaId;
    private final int operationNumber;
    private final int changeCount;
    private String csnStr;
    private byte[] bytes;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final String[] PADDING_6;
    private static final String[] PADDING_3;

    public Csn(long timestamp, int changeCount, int replicaId, int operationNumber) {
        this.timestamp = timestamp;
        this.replicaId = replicaId;
        this.operationNumber = operationNumber;
        this.changeCount = changeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Csn(String value) throws InvalidCSNException {
        if (Strings.isEmpty((String)value)) {
            String message = I18n.err((I18n)I18n.ERR_04114, (Object[])new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        if (value.length() != 40) {
            String message = I18n.err((I18n)I18n.ERR_04115, (Object[])new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        int sepTS = value.indexOf(35);
        if (sepTS < 0) {
            String message = I18n.err((I18n)I18n.ERR_04116, (Object[])new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String timestampStr = value.substring(0, sepTS).trim();
        if (timestampStr.length() != 22) {
            String message = I18n.err((I18n)I18n.ERR_04117, (Object[])new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String realTimestamp = timestampStr.substring(0, 14);
        long tempTimestamp = 0L;
        SimpleDateFormat simpleDateFormat = SDF;
        synchronized (simpleDateFormat) {
            try {
                tempTimestamp = SDF.parse(realTimestamp).getTime();
            }
            catch (ParseException pe) {
                String message = I18n.err((I18n)I18n.ERR_04118, (Object[])new Object[]{timestampStr});
                LOG.error(message);
                throw new InvalidCSNException(message);
            }
        }
        int millis = 0;
        try {
            millis = Integer.valueOf(timestampStr.substring(15, 21));
        }
        catch (NumberFormatException nfe) {
            String message = I18n.err((I18n)I18n.ERR_04119, (Object[])new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        this.timestamp = tempTimestamp += (long)(millis / 1000);
        int sepCC = value.indexOf(35, sepTS + 1);
        if (sepCC < 0) {
            String message = I18n.err((I18n)I18n.ERR_04110, (Object[])new Object[]{value});
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String changeCountStr = value.substring(sepTS + 1, sepCC).trim();
        try {
            this.changeCount = Integer.parseInt(changeCountStr, 16);
        }
        catch (NumberFormatException nfe) {
            String message = I18n.err((I18n)I18n.ERR_04121, (Object[])new Object[]{changeCountStr});
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        int sepRI = value.indexOf(35, sepCC + 1);
        if (sepRI < 0) {
            String message = I18n.err((I18n)I18n.ERR_04122, (Object[])new Object[]{value});
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String replicaIdStr = value.substring(sepCC + 1, sepRI).trim();
        if (Strings.isEmpty((String)replicaIdStr)) {
            String message = I18n.err((I18n)I18n.ERR_04123, (Object[])new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        try {
            this.replicaId = Integer.parseInt(replicaIdStr, 16);
        }
        catch (NumberFormatException nfe) {
            String message = I18n.err((I18n)I18n.ERR_04124, (Object[])new Object[]{replicaIdStr});
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        if (sepCC == value.length()) {
            String message = I18n.err((I18n)I18n.ERR_04125, (Object[])new Object[0]);
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        String operationNumberStr = value.substring(sepRI + 1).trim();
        try {
            this.operationNumber = Integer.parseInt(operationNumberStr, 16);
        }
        catch (NumberFormatException nfe) {
            String message = I18n.err((I18n)I18n.ERR_04126, (Object[])new Object[]{operationNumberStr});
            LOG.error(message);
            throw new InvalidCSNException(message);
        }
        this.csnStr = value;
        this.bytes = Strings.getBytesUtf8((String)this.csnStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValid(String value) {
        if (Strings.isEmpty((String)value)) {
            return false;
        }
        if (value.length() != 40) {
            return false;
        }
        int sepTS = value.indexOf(35);
        if (sepTS < 0) {
            return false;
        }
        String timestampStr = value.substring(0, sepTS).trim();
        if (timestampStr.length() != 22) {
            return false;
        }
        String realTimestamp = timestampStr.substring(0, 14);
        SimpleDateFormat simpleDateFormat = SDF;
        synchronized (simpleDateFormat) {
            try {
                SDF.parse(realTimestamp).getTime();
            }
            catch (ParseException pe) {
                return false;
            }
        }
        String millisStr = timestampStr.substring(15, 21);
        if (Strings.isEmpty((String)millisStr)) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (Chars.isDigit((String)millisStr, (int)i)) continue;
            return false;
        }
        try {
            Integer.valueOf(millisStr);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        int sepCC = value.indexOf(35, sepTS + 1);
        if (sepCC < 0) {
            return false;
        }
        String changeCountStr = value.substring(sepTS + 1, sepCC).trim();
        if (Strings.isEmpty((String)changeCountStr)) {
            return false;
        }
        if (changeCountStr.length() != 6) {
            return false;
        }
        try {
            for (int i = 0; i < 6; ++i) {
                if (Chars.isHex((String)changeCountStr, (int)i)) continue;
                return false;
            }
            Integer.parseInt(changeCountStr, 16);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        int sepRI = value.indexOf(35, sepCC + 1);
        if (sepRI < 0) {
            return false;
        }
        String replicaIdStr = value.substring(sepCC + 1, sepRI).trim();
        if (Strings.isEmpty((String)replicaIdStr)) {
            return false;
        }
        if (replicaIdStr.length() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (Chars.isHex((String)replicaIdStr, (int)i)) continue;
            return false;
        }
        try {
            Integer.parseInt(replicaIdStr, 16);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (sepCC == value.length()) {
            return false;
        }
        String operationNumberStr = value.substring(sepRI + 1).trim();
        if (operationNumberStr.length() != 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (Chars.isHex((String)operationNumberStr, (int)i)) continue;
            return false;
        }
        try {
            Integer.parseInt(operationNumberStr, 16);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    Csn(byte[] value) {
        this.csnStr = Strings.utf8ToString((byte[])value);
        Csn csn = new Csn(this.csnStr);
        this.timestamp = csn.timestamp;
        this.changeCount = csn.changeCount;
        this.replicaId = csn.replicaId;
        this.operationNumber = csn.operationNumber;
        this.bytes = Strings.getBytesUtf8((String)this.csnStr);
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = Strings.getBytesUtf8((String)this.csnStr);
        }
        byte[] copy = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
        return copy;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public int getReplicaId() {
        return this.replicaId;
    }

    public int getOperationNumber() {
        return this.operationNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.csnStr == null) {
            StringBuilder buf = new StringBuilder(40);
            SimpleDateFormat simpleDateFormat = SDF;
            synchronized (simpleDateFormat) {
                buf.append(SDF.format(new Date(this.timestamp)));
            }
            long millis = this.timestamp % 1000L * 1000L;
            String millisStr = Long.toString(millis);
            buf.append('.').append(PADDING_6[millisStr.length() - 1]).append(millisStr).append("Z#");
            String countStr = Integer.toHexString(this.changeCount);
            buf.append(PADDING_6[countStr.length() - 1]).append(countStr);
            buf.append('#');
            String replicaIdStr = Integer.toHexString(this.replicaId);
            buf.append(PADDING_3[replicaIdStr.length() - 1]).append(replicaIdStr);
            buf.append('#');
            String operationNumberStr = Integer.toHexString(this.operationNumber);
            buf.append(PADDING_6[operationNumberStr.length() - 1]).append(operationNumberStr);
            this.csnStr = buf.toString();
        }
        return this.csnStr;
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + (int)(this.timestamp ^ this.timestamp >>> 32);
        h = h * 17 + this.changeCount;
        h = h * 17 + this.replicaId;
        h = h * 17 + this.operationNumber;
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Csn)) {
            return false;
        }
        Csn that = (Csn)o;
        return this.timestamp == that.timestamp && this.changeCount == that.changeCount && this.replicaId == that.replicaId && this.operationNumber == that.operationNumber;
    }

    @Override
    public int compareTo(Csn csn) {
        if (csn == null) {
            return 1;
        }
        if (this.timestamp < csn.timestamp) {
            return -1;
        }
        if (this.timestamp > csn.timestamp) {
            return 1;
        }
        if (this.changeCount < csn.changeCount) {
            return -1;
        }
        if (this.changeCount > csn.changeCount) {
            return 1;
        }
        int replicaIdCompareResult = this.getReplicaIdCompareResult(csn);
        if (replicaIdCompareResult != 0) {
            return replicaIdCompareResult;
        }
        if (this.operationNumber < csn.operationNumber) {
            return -1;
        }
        if (this.operationNumber > csn.operationNumber) {
            return 1;
        }
        return 0;
    }

    private int getReplicaIdCompareResult(Csn csn) {
        if (this.replicaId < csn.replicaId) {
            return -1;
        }
        if (this.replicaId > csn.replicaId) {
            return 1;
        }
        return 0;
    }

    static {
        SDF.setTimeZone(UTC_TIME_ZONE);
        PADDING_6 = new String[]{"00000", "0000", "000", "00", "0", ""};
        PADDING_3 = new String[]{"00", "0", ""};
    }
}

