/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.LinkedList;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BorrowedFromLeftResult;
import org.apache.directory.mavibot.btree.BorrowedFromRightResult;
import org.apache.directory.mavibot.btree.Cursor;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.DuplicateKeyMemoryHolder;
import org.apache.directory.mavibot.btree.ElementHolder;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.InternalUtil;
import org.apache.directory.mavibot.btree.MemoryHolder;
import org.apache.directory.mavibot.btree.MergedWithSiblingResult;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.Node;
import org.apache.directory.mavibot.btree.NotPresentResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.RemoveResult;
import org.apache.directory.mavibot.btree.SplitResult;
import org.apache.directory.mavibot.btree.Transaction;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;

class Leaf<K, V>
extends AbstractPage<K, V> {
    protected ElementHolder<V, K, V>[] values;

    Leaf(BTree<K, V> btree) {
        super(btree);
    }

    Leaf(BTree<K, V> btree, long revision, int nbElems) {
        super(btree, revision, nbElems);
        this.values = btree.isAllowDuplicates() ? (DuplicateKeyMemoryHolder[])Array.newInstance(DuplicateKeyMemoryHolder.class, nbElems) : (MemoryHolder[])Array.newInstance(MemoryHolder.class, nbElems);
    }

    @Override
    public InsertResult<K, V> insert(long revision, K key, V value) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            int index = -(pos + 1);
            InsertResult<K, V> result = this.replaceElement(revision, key, value, index);
            return result;
        }
        if (this.nbElems < this.btree.getPageSize()) {
            Page<K, V> modifiedPage = this.addElement(revision, key, value, pos);
            ModifyResult<K, Object> result = new ModifyResult<K, Object>(modifiedPage, null);
            result.addCopiedPage(this);
            return result;
        }
        InsertResult<K, V> result = this.addAndSplit(revision, key, value, pos);
        result.addCopiedPage(this);
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DeleteResult<K, V> delete(long revision, K key, V value, Page<K, V> parent, int parentPos) throws IOException {
        void var8_13;
        if (this.nbElems == 0) {
            return NotPresentResult.NOT_PRESENT;
        }
        int pos = this.findPos(key);
        if (pos >= 0) {
            return NotPresentResult.NOT_PRESENT;
        }
        Object var8_7 = null;
        boolean keyRemoved = false;
        int index = -(pos + 1);
        if (this.btree.isAllowDuplicates()) {
            BTree dups = (BTree)this.values[index].getValue(this.btree);
            if (dups.hasKey(value)) {
                dups.delete(value);
                if (dups.getNbElems() == 0L) {
                    keyRemoved = true;
                }
                Tuple<Object, V> tuple = new Tuple<Object, V>(this.keys[index], value);
            } else {
                if (value != null) return NotPresentResult.NOT_PRESENT;
                Tuple<Object, BTree> tuple = new Tuple<Object, BTree>(this.keys[index], dups);
                keyRemoved = true;
            }
        } else {
            V existing = this.values[index].getValue(this.btree);
            if (existing == null && value == null || value == null) {
                Tuple<Object, V> tuple = new Tuple<Object, V>(this.keys[index], existing);
                keyRemoved = true;
            } else {
                if (this.btree.getValueSerializer().compare(value, existing) != 0) return NotPresentResult.NOT_PRESENT;
                Tuple<Object, V> tuple = new Tuple<Object, V>(this.keys[index], value);
                keyRemoved = true;
            }
        }
        Leaf<K, V> newLeaf = null;
        newLeaf = keyRemoved ? new Leaf<K, V>(this.btree, revision, this.nbElems - 1) : new Leaf<K, V>(this.btree, revision, this.nbElems);
        RemoveResult<K, V> defaultResult = new RemoveResult<K, V>(newLeaf, var8_13);
        if (parent == null) {
            this.copyAfterRemovingElement(keyRemoved, newLeaf, index);
            defaultResult.addCopiedPage(this);
            return defaultResult;
        }
        if (keyRemoved) {
            int halfSize = this.btree.getPageSize() / 2;
            if (this.nbElems == halfSize) {
                int siblingPos = this.selectSibling((Node)parent, parentPos);
                Leaf sibling = (Leaf)((Node)parent).children[siblingPos].getValue(this.btree);
                if (sibling.getNbElems() == halfSize) {
                    return this.mergeWithSibling((Tuple<K, V>)var8_13, revision, sibling, siblingPos < parentPos, index);
                }
                if (siblingPos >= parentPos) return this.borrowFromRight((Tuple<K, V>)var8_13, revision, sibling, index);
                return this.borrowFromLeft((Tuple<K, V>)var8_13, revision, sibling, index);
            }
            this.copyAfterRemovingElement(keyRemoved, newLeaf, index);
            defaultResult.addCopiedPage(this);
            return defaultResult;
        }
        System.arraycopy(this.keys, 0, newLeaf.keys, 0, this.nbElems);
        System.arraycopy(this.values, 0, newLeaf.values, 0, this.nbElems);
        defaultResult.addCopiedPage(this);
        return defaultResult;
    }

    private DeleteResult<K, V> mergeWithSibling(Tuple<K, V> removedElement, long revision, Leaf<K, V> sibling, boolean isLeft, int pos) throws EndOfFileExceededException, IOException {
        Leaf<K, V> newLeaf = new Leaf<K, V>(this.btree, revision, this.btree.getPageSize() - 1);
        if (isLeft) {
            System.arraycopy(sibling.keys, 0, newLeaf.keys, 0, sibling.nbElems);
            System.arraycopy(sibling.values, 0, newLeaf.values, 0, sibling.nbElems);
            System.arraycopy(this.keys, 0, newLeaf.keys, sibling.nbElems, pos);
            System.arraycopy(this.values, 0, newLeaf.values, sibling.nbElems, pos);
            System.arraycopy(this.keys, pos + 1, newLeaf.keys, sibling.nbElems + pos, this.nbElems - pos - 1);
            System.arraycopy(this.values, pos + 1, newLeaf.values, sibling.nbElems + pos, this.nbElems - pos - 1);
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos, this.nbElems - pos - 1);
            System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.nbElems - pos - 1);
            System.arraycopy(sibling.keys, 0, newLeaf.keys, this.nbElems - 1, sibling.nbElems);
            System.arraycopy(sibling.values, 0, newLeaf.values, this.nbElems - 1, sibling.nbElems);
        }
        MergedWithSiblingResult<K, V> result = new MergedWithSiblingResult<K, V>(newLeaf, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromLeft(Tuple<K, V> removedElement, long revision, Leaf<K, V> sibling, int pos) throws IOException {
        Object siblingKey = sibling.keys[sibling.getNbElems() - 1];
        ElementHolder<V, K, V> siblingValue = sibling.values[sibling.getNbElems() - 1];
        Leaf newSibling = (Leaf)super.copy(revision, sibling.getNbElems() - 1);
        Leaf<K, V> newLeaf = new Leaf<K, V>(this.btree, revision, this.nbElems);
        newLeaf.keys[0] = siblingKey;
        newLeaf.values[0] = siblingValue;
        System.arraycopy(this.keys, 0, newLeaf.keys, 1, pos);
        System.arraycopy(this.values, 0, newLeaf.values, 1, pos);
        System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos + 1, this.keys.length - pos - 1);
        System.arraycopy(this.values, pos + 1, newLeaf.values, pos + 1, this.values.length - pos - 1);
        BorrowedFromLeftResult<K, V> result = new BorrowedFromLeftResult<K, V>(newLeaf, newSibling, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromRight(Tuple<K, V> removedElement, long revision, Leaf<K, V> sibling, int pos) throws IOException {
        Object siblingKey = sibling.keys[0];
        ElementHolder<V, K, V> siblingHolder = sibling.values[0];
        Leaf<K, V> newSibling = new Leaf<K, V>(this.btree, revision, sibling.getNbElems() - 1);
        System.arraycopy(sibling.keys, 1, newSibling.keys, 0, sibling.nbElems - 1);
        System.arraycopy(sibling.values, 1, newSibling.values, 0, sibling.nbElems - 1);
        Leaf<K, V> newLeaf = new Leaf<K, V>(this.btree, revision, this.nbElems);
        newLeaf.keys[this.nbElems - 1] = siblingKey;
        newLeaf.values[this.nbElems - 1] = siblingHolder;
        System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
        System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
        System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos, this.keys.length - pos - 1);
        System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.values.length - pos - 1);
        BorrowedFromRightResult<K, V> result = new BorrowedFromRightResult<K, V>(newLeaf, newSibling, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private void copyAfterRemovingElement(boolean keyRemoved, Leaf<K, V> newLeaf, int pos) throws IOException {
        if (keyRemoved) {
            if (this.nbElems == 1) {
                return;
            }
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            System.arraycopy(this.keys, pos + 1, newLeaf.keys, pos, this.keys.length - pos - 1);
            System.arraycopy(this.values, pos + 1, newLeaf.values, pos, this.values.length - pos - 1);
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, this.nbElems);
            System.arraycopy(this.values, 0, newLeaf.values, 0, this.nbElems);
        }
    }

    @Override
    public V get(K key) throws KeyNotFoundException, IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            V v = this.values[-(pos + 1)].getValue(this.btree);
            if (this.btree.isAllowDuplicates()) {
                BTree dupTree = (BTree)v;
                return (V)dupTree.rootPage.getLeftMostKey();
            }
            return v;
        }
        throw new KeyNotFoundException("Cannot find an entry for key " + key);
    }

    @Override
    public BTree<V, V> getValues(K key) throws KeyNotFoundException, IOException, IllegalArgumentException {
        if (!this.btree.isAllowDuplicates()) {
            throw new IllegalArgumentException("Duplicates are not allowed in this tree");
        }
        int pos = this.findPos(key);
        if (pos < 0) {
            V v = this.values[-(pos + 1)].getValue(this.btree);
            return (BTree)v;
        }
        throw new KeyNotFoundException("Cannot find an entry for key " + key);
    }

    @Override
    public boolean hasKey(K key) {
        int pos = this.findPos(key);
        return pos < 0;
    }

    @Override
    public boolean contains(K key, V value) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            V v = this.values[-(pos + 1)].getValue(this.btree);
            if (this.btree.isAllowDuplicates()) {
                BTree dupTree = (BTree)v;
                return dupTree.hasKey(value);
            }
            return this.btree.getValueSerializer().compare(value, v) == 0;
        }
        return false;
    }

    public ElementHolder<V, K, V> getValue(int pos) {
        if (pos < this.nbElems) {
            return this.values[pos];
        }
        return null;
    }

    public void setValue(int pos, ElementHolder<V, K, V> value) {
        this.values[pos] = value;
    }

    @Override
    public Cursor<K, V> browse(K key, Transaction<K, V> transaction, LinkedList<ParentPos<K, V>> stack) {
        int pos = this.findPos(key);
        Cursor<K, V> cursor = null;
        if (pos < 0) {
            int index = -(pos + 1);
            ParentPos parentPos = new ParentPos(this, index);
            InternalUtil.setDupsContainer(parentPos, this.btree);
            stack.push(parentPos);
            cursor = new Cursor<K, V>(this.btree, transaction, stack);
        } else if (pos < this.nbElems) {
            ParentPos parentPos = new ParentPos(this, pos);
            InternalUtil.setDupsContainer(parentPos, this.btree);
            stack.push(parentPos);
            cursor = new Cursor<K, V>(this.btree, transaction, stack);
        } else {
            stack.push(new ParentPos(null, -1));
            return new Cursor<K, V>(this.btree, transaction, stack);
        }
        return cursor;
    }

    @Override
    public Cursor<K, V> browse(Transaction<K, V> transaction, LinkedList<ParentPos<K, V>> stack) {
        int pos = 0;
        Cursor<K, V> cursor = null;
        if (this.nbElems == 0) {
            stack.push(new ParentPos(null, -1));
            return new Cursor<K, V>(this.btree, transaction, stack);
        }
        ParentPos parentPos = new ParentPos(this, pos);
        InternalUtil.setDupsContainer(parentPos, this.btree);
        stack.push(parentPos);
        cursor = new Cursor<K, V>(this.btree, transaction, stack);
        return cursor;
    }

    private Page<K, V> copy(long revision, int nbElems) {
        Leaf<K, V> newLeaf = new Leaf<K, V>(this.btree, revision, nbElems);
        System.arraycopy(this.keys, 0, newLeaf.keys, 0, nbElems);
        System.arraycopy(this.values, 0, newLeaf.values, 0, nbElems);
        return newLeaf;
    }

    private InsertResult<K, V> replaceElement(long revision, K key, V value, int pos) throws IOException {
        Leaf newLeaf = this;
        if (this.revision != revision) {
            newLeaf = (Leaf)this.copy(revision, this.nbElems);
        }
        Object oldValue = null;
        if (this.btree.isAllowDuplicates()) {
            BTree dupValues = (BTree)newLeaf.values[pos].getValue(this.btree);
            if (!dupValues.hasKey(value)) {
                dupValues.insert(value, null, 0L);
            } else {
                oldValue = value;
            }
        } else {
            oldValue = newLeaf.values[pos].getValue(this.btree);
            newLeaf.values[pos] = this.btree.createHolder(value);
        }
        ModifyResult result = new ModifyResult(newLeaf, oldValue);
        result.addCopiedPage(this);
        return result;
    }

    private Page<K, V> addElement(long revision, K key, V value, int pos) {
        Leaf<K, V> newLeaf = new Leaf<K, V>(this.btree, revision, this.nbElems + 1);
        ElementHolder valueHolder = null;
        valueHolder = this.btree.isAllowDuplicates() ? new DuplicateKeyMemoryHolder(this.btree, value) : new MemoryHolder(this.btree, value);
        if (this.nbElems == 0) {
            newLeaf.keys[0] = key;
            newLeaf.values[0] = valueHolder;
        } else {
            System.arraycopy(this.keys, 0, newLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, newLeaf.values, 0, pos);
            newLeaf.keys[pos] = key;
            newLeaf.values[pos] = valueHolder;
            System.arraycopy(this.keys, pos, newLeaf.keys, pos + 1, this.keys.length - pos);
            System.arraycopy(this.values, pos, newLeaf.values, pos + 1, this.values.length - pos);
        }
        return newLeaf;
    }

    private InsertResult<K, V> addAndSplit(long revision, K key, V value, int pos) {
        int middle = this.btree.getPageSize() >> 1;
        Leaf<K, V> leftLeaf = null;
        Leaf<K, V> rightLeaf = null;
        ElementHolder valueHolder = this.btree.createHolder(value);
        if (pos <= middle) {
            leftLeaf = new Leaf<K, V>(this.btree, revision, middle + 1);
            System.arraycopy(this.keys, 0, leftLeaf.keys, 0, pos);
            System.arraycopy(this.values, 0, leftLeaf.values, 0, pos);
            leftLeaf.keys[pos] = key;
            leftLeaf.values[pos] = valueHolder;
            System.arraycopy(this.keys, pos, leftLeaf.keys, pos + 1, middle - pos);
            System.arraycopy(this.values, pos, leftLeaf.values, pos + 1, middle - pos);
            rightLeaf = new Leaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.keys, middle, rightLeaf.keys, 0, middle);
            System.arraycopy(this.values, middle, rightLeaf.values, 0, middle);
        } else {
            leftLeaf = new Leaf<K, V>(this.btree, revision, middle);
            System.arraycopy(this.keys, 0, leftLeaf.keys, 0, middle);
            System.arraycopy(this.values, 0, leftLeaf.values, 0, middle);
            rightLeaf = new Leaf<K, V>(this.btree, revision, middle + 1);
            int rightPos = pos - middle;
            System.arraycopy(this.keys, middle, rightLeaf.keys, 0, rightPos);
            System.arraycopy(this.values, middle, rightLeaf.values, 0, rightPos);
            rightLeaf.keys[rightPos] = key;
            rightLeaf.values[rightPos] = valueHolder;
            System.arraycopy(this.keys, pos, rightLeaf.keys, rightPos + 1, this.nbElems - pos);
            System.arraycopy(this.values, pos, rightLeaf.values, rightPos + 1, this.nbElems - pos);
        }
        Object pivot = rightLeaf.keys[0];
        SplitResult<Object, V> result = new SplitResult<Object, V>(pivot, leftLeaf, rightLeaf);
        return result;
    }

    @Override
    public K getLeftMostKey() {
        return (K)this.keys[0];
    }

    @Override
    public K getRightMostKey() {
        return (K)this.keys[this.nbElems - 1];
    }

    @Override
    public Tuple<K, V> findLeftMost() throws IOException {
        Object val = null;
        if (this.btree.isAllowDuplicates()) {
            BTree dupTree = (BTree)this.values[0].getValue(this.btree);
            val = dupTree.rootPage.getLeftMostKey();
        } else {
            val = this.values[0].getValue(this.btree);
        }
        return new Tuple<Object, Object>(this.keys[0], val);
    }

    @Override
    public Tuple<K, V> findRightMost() throws EndOfFileExceededException, IOException {
        Object val = null;
        if (this.btree.isAllowDuplicates()) {
            BTree dupTree = (BTree)this.values[this.nbElems - 1].getValue(this.btree);
            val = dupTree.rootPage.getRightMostKey();
        } else {
            val = this.values[this.nbElems - 1].getValue(this.btree);
        }
        return new Tuple<Object, Object>(this.keys[this.nbElems - 1], val);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Leaf[");
        sb.append(super.toString());
        sb.append("] -> {");
        if (this.nbElems > 0) {
            boolean isFirst = true;
            for (int i = 0; i < this.nbElems; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<").append(this.keys[i]).append(",").append(this.values[i]).append(">");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String dumpPage(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs);
        if (this.nbElems > 0) {
            boolean isFirst = true;
            for (int i = 0; i < this.nbElems; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("<").append(this.keys[i]).append(",").append(this.values[i]).append(">");
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

